/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import gnu.javax.security.auth.login.GnuConfiguration;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;

public abstract class Configuration {
    private static Configuration config;

    protected Configuration() {
    }

    public static synchronized Configuration getConfiguration() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        return Configuration.getConfig();
    }

    public static synchronized void setConfiguration(Configuration config) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        Configuration.config = config;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();

    static Configuration getConfig() {
        if (config == null) {
            String conf = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("login.configuration.provider");
                }
            });
            try {
                config = conf != null ? (Configuration)Class.forName(conf).newInstance() : new GnuConfiguration();
            }
            catch (Exception exception) {
                config = new GnuConfiguration();
            }
        }
        return config;
    }
}

