/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import gnu.gcj.runtime.HelperClassLoader;
import gnu.java.net.protocol.core.Handler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class BootClassLoader
extends HelperClassLoader {
    static Class coreHandler = Handler.class;
    private boolean initialized;
    private URLClassLoader bootURLLoader;

    BootClassLoader(String libdir) {
        super((ClassLoader)null);
        this.addDirectoriesFromProperty("java.endorsed.dirs");
        this.addDirectoriesFromProperty("gnu.gcj.runtime.endorsed.dirs");
        try {
            this.addURL(new URL("core", "", -1, "/"));
        }
        catch (MalformedURLException x) {
            throw new RuntimeException(x);
        }
    }

    public Class bootLoadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                c = null;
            }
        }
        return c;
    }

    private synchronized URLClassLoader getBootURLLoader() {
        if (this.initialized) {
            return this.bootURLLoader;
        }
        this.initialized = true;
        Vector<URL> urls = new Vector<URL>();
        String bootClasspath = System.getProperty("sun.boot.class.path");
        StringTokenizer st = new StringTokenizer(bootClasspath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            try {
                urls.add(new File(st.nextToken()).toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (urls.size() > 0) {
            this.bootURLLoader = new URLClassLoader(urls.toArray((S[])new URL[urls.size()]));
        }
        return this.bootURLLoader;
    }

    public URL bootGetResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        URLClassLoader loader = this.getBootURLLoader();
        if (loader != null) {
            url = loader.findResource(name);
        }
        return url;
    }

    public Enumeration bootGetResources(String name) throws IOException {
        URLClassLoader loader = this.getBootURLLoader();
        Enumeration[] e = new Enumeration[]{this.findResources(name), loader != null ? loader.findResources(name) : null};
        Vector v = new Vector();
        Enumeration[] enumerationArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            Enumeration en = enumerationArray[n2];
            if (en != null) {
                while (en.hasMoreElements()) {
                    v.add(en.nextElement());
                }
            }
            ++n2;
        }
        return v.elements();
    }
}

