/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.javax.crypto.key.dh.DHKeyPairRawCodec;
import gnu.javax.crypto.key.dh.DHKeyPairX509Codec;
import gnu.javax.crypto.key.dh.GnuDHKey;
import java.math.BigInteger;
import java.security.AccessController;
import javax.crypto.interfaces.DHPublicKey;

public class GnuDHPublicKey
extends GnuDHKey
implements DHPublicKey {
    private BigInteger y;
    private transient String str;

    public GnuDHPublicKey(BigInteger q, BigInteger p, BigInteger g, BigInteger y) {
        this(1, q, p, g, y);
    }

    public GnuDHPublicKey(int preferredFormat, BigInteger q, BigInteger p, BigInteger g, BigInteger y) {
        super(preferredFormat == 4 ? 2 : preferredFormat, q, p, g);
        this.y = y;
    }

    public static GnuDHPublicKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_DH_PUBLIC_KEY[0]) {
            try {
                return (GnuDHPublicKey)new DHKeyPairRawCodec().decodePublicKey(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (GnuDHPublicKey)new DHKeyPairX509Codec().decodePublicKey(k);
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new DHKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            case 2: {
                result = new DHKeyPairX509Codec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + format);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DHPublicKey)) {
            return false;
        }
        DHPublicKey that = (DHPublicKey)obj;
        return super.equals(that) && this.y.equals(that.getY());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + ls + "y=0x" + this.y.toString(16) + ls + ")";
        }
        return this.str;
    }
}

