/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private File cacheDir;

    public FileCacheImageInputStream(InputStream stream, File cacheDir) throws IOException {
        this.stream = stream;
        this.cacheDir = cacheDir;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private void checkStreamClosed() throws IOException {
        if (this.stream == null) {
            throw new IOException("stream closed");
        }
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public int read() throws IOException {
        this.checkStreamClosed();
        this.setBitOffset(0);
        return this.stream.read();
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        this.checkStreamClosed();
        this.setBitOffset(0);
        return this.stream.read(data, offset, len);
    }
}

