/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class UnsignedLongType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};
    static final String MAX_VALUE = "18446744073709551615";
    static final int LENGTH = "18446744073709551615".length();

    UnsignedLongType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "unsignedLong"), TypeLibrary.NON_NEGATIVE_INTEGER);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        if (len == 0) {
            throw new DatatypeException(0, "invalid unsigned long value");
        }
        boolean compare = false;
        int i = 0;
        while (i < len) {
            char c;
            if (len - i > LENGTH) {
                throw new DatatypeException(i, "invalid unsigned long value");
            }
            if (len - i == LENGTH) {
                compare = true;
            }
            if ((c = value.charAt(i)) >= '0' && c <= '9') {
                if (compare) {
                    char d = MAX_VALUE.charAt(i);
                    if (Character.digit(c, 10) > Character.digit(d, 10)) {
                        throw new DatatypeException(i, "invalid unsigned long value");
                    }
                }
            } else {
                throw new DatatypeException(i, "invalid unsigned long value");
            }
            ++i;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new Long(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

