/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.LongBufferImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    final int array_offset;
    final long[] backing_buffer;

    LongBuffer(int capacity, int limit, int position, int mark, RawData address, long[] backing_buffer, int array_offset) {
        super(capacity, limit, position, mark, address);
        this.backing_buffer = backing_buffer;
        this.array_offset = array_offset;
    }

    public static LongBuffer allocate(int capacity) {
        return new LongBufferImpl(capacity);
    }

    public static final LongBuffer wrap(long[] array, int offset, int length) {
        return new LongBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final LongBuffer wrap(long[] array) {
        return LongBuffer.wrap(array, 0, array.length);
    }

    public LongBuffer get(long[] dst, int offset, int length) {
        LongBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public LongBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public LongBuffer put(LongBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            long[] toPut = new long[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public LongBuffer put(long[] src, int offset, int length) {
        LongBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final LongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final long[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        long hashCode = this.get(this.position()) + 31L;
        long multiplier = 1L;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (this.get(i) + 30L) * (multiplier *= 31L);
            ++i;
        }
        return (int)hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongBuffer) {
            return this.compareTo((LongBuffer)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(LongBuffer other) {
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            long b;
            long a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer compact();

    public abstract boolean isDirect();

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();
}

