/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import gnu.java.security.action.GetSecurityPropertyAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LoginContext {
    private static final String OTHER = "other";
    private final String name;
    private final CallbackHandler cbHandler;
    private final Subject subject;
    private final AppConfigurationEntry[] entries;
    private final LoginModule[] modules;
    private final Map sharedState;

    public LoginContext(String name) throws LoginException {
        this(name, new Subject(), LoginContext.defaultHandler());
    }

    public LoginContext(String name, CallbackHandler cbHandler) throws LoginException {
        this(name, new Subject(), cbHandler);
    }

    public LoginContext(String name, Subject subject) throws LoginException {
        this(name, subject, LoginContext.defaultHandler());
    }

    public LoginContext(String name, Subject subject, CallbackHandler cbHandler) throws LoginException {
        this(name, subject, cbHandler, null);
    }

    public LoginContext(String name, Subject subject, CallbackHandler cbHandler, Configuration config) throws LoginException {
        AppConfigurationEntry[] entries;
        this.name = name;
        this.subject = subject;
        this.cbHandler = cbHandler;
        if (config == null) {
            config = Configuration.getConfig();
        }
        if ((entries = config.getAppConfigurationEntry(name)) == null) {
            entries = config.getAppConfigurationEntry(OTHER);
        }
        if (entries == null) {
            throw new LoginException("no configured modules for application " + name);
        }
        this.entries = entries;
        this.modules = new LoginModule[entries.length];
        this.sharedState = new HashMap();
        int i = 0;
        while (i < entries.length) {
            this.modules[i] = this.lookupModule(entries[i], subject, this.sharedState);
            ++i;
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    /*
     * Unable to fully structure code
     */
    public void login() throws LoginException {
        failure = false;
        i = 0;
        while (i < this.modules.length) {
            block11: {
                try {
                    result = this.modules[i].login();
                    if (!result) {
                        if (this.entries[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                            throw new LoginException("REQUISITE module " + this.entries[i].getLoginModuleName() + " failed");
                        }
                        if (this.entries[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                            failure = true;
                        }
                    } else if (this.entries[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                        break;
                    }
                    break block11;
                }
                catch (LoginException le) {
                    if (this.entries[i].getControlFlag() != AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) break block11;
                    j = 0;
                    ** while (j < this.modules.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.modules[i].abort();
                    ++j;
                    continue;
                }
lbl23:
                // 1 sources

                throw le;
            }
            ++i;
        }
        if (failure) {
            throw new LoginException("not all REQUIRED modules succeeded");
        }
        i = 0;
        while (i < this.modules.length) {
            this.modules[i].commit();
            ++i;
        }
    }

    public void logout() throws LoginException {
        int i = 0;
        while (i < this.modules.length) {
            this.modules[i].logout();
            ++i;
        }
    }

    private static CallbackHandler defaultHandler() {
        GetSecurityPropertyAction act = new GetSecurityPropertyAction("auth.login.defaultCallbackHandler");
        String classname = AccessController.doPrivileged(act);
        if (classname != null) {
            try {
                return (CallbackHandler)Class.forName(classname).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
        }
        return null;
    }

    private LoginModule lookupModule(AppConfigurationEntry entry, Subject subject, Map sharedState) throws LoginException {
        LoginModule module = null;
        Exception cause = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> c = Class.forName(entry.getLoginModuleName(), true, cl);
            module = (LoginModule)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            cause = cnfe;
        }
        catch (ClassCastException cce) {
            cause = cce;
        }
        catch (IllegalAccessException iae) {
            cause = iae;
        }
        catch (InstantiationException ie) {
            cause = ie;
        }
        if (cause != null) {
            LoginException le = new LoginException("could not load module " + entry.getLoginModuleName());
            le.initCause(cause);
            throw le;
        }
        module.initialize(subject, this.cbHandler, sharedState, entry.getOptions());
        return module;
    }
}

