/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

class MultiAttributeSet
implements AttributeSet {
    AttributeSet[] multi;

    MultiAttributeSet() {
    }

    MultiAttributeSet(AttributeSet[] m) {
        this.init(m);
    }

    void init(AttributeSet[] m) {
        this.multi = m;
    }

    public boolean containsAttribute(Object name, Object value) {
        boolean ret = false;
        int i = 0;
        while (i < this.multi.length && !ret) {
            if (this.multi[i].containsAttribute(name, value)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public boolean containsAttributes(AttributeSet attributes) {
        boolean ret = true;
        Enumeration<?> e = attributes.getAttributeNames();
        while (ret && e.hasMoreElements()) {
            Object key = e.nextElement();
            ret = attributes.getAttribute(key).equals(this.getAttribute(key));
        }
        return ret;
    }

    public AttributeSet copyAttributes() {
        SimpleAttributeSet copy = new SimpleAttributeSet();
        int i = 0;
        while (i < this.multi.length) {
            copy.addAttributes(this.multi[i]);
            ++i;
        }
        return copy;
    }

    public Object getAttribute(Object key) {
        Object ret = null;
        int i = 0;
        while (i < this.multi.length && ret == null) {
            ret = this.multi[i].getAttribute(key);
            ++i;
        }
        return ret;
    }

    public int getAttributeCount() {
        int n = 0;
        int i = 0;
        while (i < this.multi.length) {
            n += this.multi[i].getAttributeCount();
            ++i;
        }
        return n;
    }

    public Enumeration getAttributeNames() {
        return new MultiNameEnumeration();
    }

    public AttributeSet getResolveParent() {
        return null;
    }

    public boolean isDefined(Object attrName) {
        boolean ret = false;
        int i = 0;
        while (i < this.multi.length && !ret) {
            ret = this.multi[i].isDefined(attrName);
            ++i;
        }
        return ret;
    }

    public boolean isEqual(AttributeSet attr) {
        return this.getAttributeCount() == attr.getAttributeCount() && this.containsAttributes(attr);
    }

    private class MultiNameEnumeration
    implements Enumeration {
        private int index = 0;
        private Enumeration current;

        MultiNameEnumeration() {
            this.current = MultiAttributeSet.this.multi[0].getAttributeNames();
        }

        public boolean hasMoreElements() {
            return this.current.hasMoreElements() || this.index < MultiAttributeSet.this.multi.length - 1;
        }

        public Object nextElement() {
            if (!this.current.hasMoreElements()) {
                if (this.index < MultiAttributeSet.this.multi.length - 1) {
                    ++this.index;
                    this.current = MultiAttributeSet.this.multi[this.index].getAttributeNames();
                } else {
                    throw new NoSuchElementException();
                }
            }
            return this.current.nextElement();
        }
    }
}

