/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.hash.Sha160;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.SecureRandom;

public class FIPS186 {
    public static final int DSA_PARAMS_SEED = 0;
    public static final int DSA_PARAMS_COUNTER = 1;
    public static final int DSA_PARAMS_Q = 2;
    public static final int DSA_PARAMS_P = 3;
    public static final int DSA_PARAMS_E = 4;
    public static final int DSA_PARAMS_G = 5;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger TWO_POW_160 = TWO.pow(160);
    private Sha160 sha = new Sha160();
    private int L;
    private SecureRandom rnd = null;
    private PRNG prng = null;

    public FIPS186(int L, SecureRandom rnd) {
        this.L = L;
        this.rnd = rnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger[] generateParameters() {
        BigInteger p;
        int counter;
        BigInteger q;
        BigInteger SEED;
        byte[] kb = new byte[20];
        int b = (this.L - 1) % 160;
        int n = (this.L - 1 - b) / 160;
        BigInteger[] V = new BigInteger[n + 1];
        block6: while (true) {
            byte[] u;
            byte[] a;
            this.nextRandomBytes(kb);
            SEED = new BigInteger(1, kb).setBit(159).setBit(0);
            BigInteger alpha = SEED.add(BigInteger.ONE).mod(TWO_POW_160);
            Sha160 sha160 = this.sha;
            synchronized (sha160) {
                a = SEED.toByteArray();
                this.sha.update(a, 0, a.length);
                a = this.sha.digest();
                u = alpha.toByteArray();
                this.sha.update(u, 0, u.length);
                u = this.sha.digest();
            }
            int i2 = 0;
            while (i2 < a.length) {
                int n2 = i2;
                a[n2] = (byte)(a[n2] ^ u[i2]);
                ++i2;
            }
            BigInteger U = new BigInteger(1, a);
            q = U.setBit(159).setBit(0);
            if (!q.isProbablePrime(80)) continue;
            counter = 0;
            int offset = 2;
            do {
                BigInteger c;
                BigInteger OFFSET = BigInteger.valueOf((long)offset & 0xFFFFFFFFL);
                BigInteger SEED_PLUS_OFFSET = SEED.add(OFFSET);
                Sha160 i2 = this.sha;
                synchronized (i2) {
                    int k = 0;
                    while (k <= n) {
                        a = SEED_PLUS_OFFSET.add(BigInteger.valueOf((long)k & 0xFFFFFFFFL)).mod(TWO_POW_160).toByteArray();
                        this.sha.update(a, 0, a.length);
                        V[k] = new BigInteger(1, this.sha.digest());
                        ++k;
                    }
                }
                BigInteger W = V[0];
                int k = 1;
                while (k < n) {
                    W = W.add(V[k].multiply(TWO.pow(k * 160)));
                    ++k;
                }
                BigInteger X = (W = W.add(V[n].mod(TWO.pow(b)).multiply(TWO.pow(n * 160)))).add(TWO.pow(this.L - 1));
                p = X.subtract((c = X.mod(TWO.multiply(q))).subtract(BigInteger.ONE));
                if (p.compareTo(TWO.pow(this.L - 1)) >= 0 && p.isProbablePrime(80)) break block6;
                offset += n + 1;
            } while (++counter < 4096);
        }
        BigInteger e = p.subtract(BigInteger.ONE).divide(q);
        BigInteger h = TWO;
        BigInteger p_minus_1 = p.subtract(BigInteger.ONE);
        BigInteger g = TWO;
        while (h.compareTo(p_minus_1) < 0) {
            g = h.modPow(e, p);
            if (!g.equals(BigInteger.ONE)) break;
            h = h.add(BigInteger.ONE);
        }
        return new BigInteger[]{SEED, BigInteger.valueOf(counter), q, p, e, g};
    }

    private void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            this.getDefaultPRNG().nextBytes(buffer);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

