/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.CharsetToBytesAdaptor;
import gnu.gcj.convert.IOConverter;
import gnu.gcj.convert.Output_8859_1;
import gnu.gcj.convert.Output_iconv;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class UnicodeToBytes
extends IOConverter {
    public byte[] buf;
    public int count;
    static String defaultEncoding;
    private static final int CACHE_SIZE = 4;
    private static UnicodeToBytes[] encoderCache;
    private static int currCachePos;

    static {
        encoderCache = new UnicodeToBytes[4];
        currCachePos = 0;
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnicodeToBytes getDefaultEncoder() {
        try {
            Class<UnicodeToBytes> clazz = UnicodeToBytes.class;
            synchronized (UnicodeToBytes.class) {
                if (defaultEncoding == null) {
                    String encoding = UnicodeToBytes.canonicalize(System.getProperty("file.encoding", "8859_1"));
                    String className = "gnu.gcj.convert.Output_" + encoding;
                    try {
                        Class.forName(className);
                        defaultEncoding = encoding;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError("missing default encoding " + encoding + " (class " + className + " not found)");
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return UnicodeToBytes.getEncoder(defaultEncoding);
            }
        }
        catch (Throwable throwable) {
            return new Output_8859_1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnicodeToBytes getEncoder(String encoding) throws UnsupportedEncodingException {
        String canonicalEncoding = UnicodeToBytes.canonicalize(encoding);
        Class<UnicodeToBytes> clazz = UnicodeToBytes.class;
        synchronized (UnicodeToBytes.class) {
            int i = 0;
            while (i < encoderCache.length) {
                if (encoderCache[i] != null && canonicalEncoding.equals(encoderCache[i].getName())) {
                    UnicodeToBytes rv = encoderCache[i];
                    UnicodeToBytes.encoderCache[i] = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return rv;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String className = "gnu.gcj.convert.Output_" + canonicalEncoding;
            try {
                Class<?> encodingClass = Class.forName(className);
                return (UnicodeToBytes)encodingClass.newInstance();
            }
            catch (Throwable ex) {
                try {
                    return new Output_iconv(encoding);
                }
                catch (Throwable throwable) {
                    try {
                        return new CharsetToBytesAdaptor(Charset.forName(encoding));
                    }
                    catch (Throwable throwable2) {
                        throw new UnsupportedEncodingException(String.valueOf(encoding) + " (" + ex + ')');
                    }
                }
            }
        }
    }

    public final void setOutput(byte[] buffer, int count) {
        this.buf = buffer;
        this.count = count;
    }

    public abstract int write(char[] var1, int var2, int var3);

    public int write(String str, int inpos, int inlength, char[] work) {
        if (work == null) {
            work = new char[inlength];
        }
        int srcEnd = inpos + (inlength > work.length ? work.length : inlength);
        str.getChars(inpos, srcEnd, work, 0);
        return this.write(work, 0, srcEnd - inpos);
    }

    public boolean havePendingBytes() {
        return false;
    }

    public void setFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Class<UnicodeToBytes> clazz = UnicodeToBytes.class;
        synchronized (UnicodeToBytes.class) {
            this.buf = null;
            this.count = 0;
            UnicodeToBytes.encoderCache[UnicodeToBytes.currCachePos] = this;
            currCachePos = (currCachePos + 1) % 4;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

