/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.javax.crypto.kwa.AESKeyWrap;
import gnu.javax.crypto.kwa.BaseKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.IKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.TripleDESKeyWrap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyWrappingAlgorithmFactory {
    private static Set names;

    private KeyWrappingAlgorithmFactory() {
    }

    public static final IKeyWrappingAlgorithm getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        BaseKeyWrappingAlgorithm result = null;
        if (name.equalsIgnoreCase("kw-aes") || name.equalsIgnoreCase("kw-aes128") || name.equalsIgnoreCase("kw-aes192") || name.equalsIgnoreCase("kw-aes256") || name.equalsIgnoreCase("kw-rijndael")) {
            result = new AESKeyWrap();
        } else if (name.equalsIgnoreCase("kw-tripledes") || name.equalsIgnoreCase("kw-desede")) {
            result = new TripleDESKeyWrap();
        }
        return result;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet<String> hs = new HashSet<String>();
            hs.add("kw-aes");
            hs.add("kw-aes128");
            hs.add("kw-aes192");
            hs.add("kw-aes256");
            hs.add("kw-rijndael");
            hs.add("kw-tripledes");
            hs.add("kw-desede");
            names = Collections.unmodifiableSet(hs);
        }
        return names;
    }
}

