/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.channels.FileChannelImpl;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileChannelImpl ch;
    private FileDescriptor fd;
    private DataOutputStream out;
    private DataInputStream in;

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        int fdmode;
        if (mode.equals("r")) {
            fdmode = 1;
        } else if (mode.equals("rw")) {
            fdmode = 3;
        } else if (mode.equals("rws")) {
            fdmode = 19;
        } else if (mode.equals("rwd")) {
            fdmode = 35;
        } else {
            throw new IllegalArgumentException("invalid mode: " + mode);
        }
        String fileName = file.getPath();
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(fileName);
            if ((fdmode & 2) != 0) {
                s.checkWrite(fileName);
            }
        }
        this.ch = FileChannelImpl.create(file, fdmode);
        this.fd = new FileDescriptor(this.ch);
        this.out = (fdmode & 2) != 0 ? new DataOutputStream(new FileOutputStream(this.fd)) : null;
        this.in = new DataInputStream(new FileInputStream(this.fd));
    }

    public RandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        this(new File(fileName), mode);
    }

    public void close() throws IOException {
        this.ch.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileDescriptor getFD() throws IOException {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.fd == null) {
                this.fd = new FileDescriptor(this.ch);
            }
            return this.fd;
        }
    }

    public long getFilePointer() throws IOException {
        return this.ch.position();
    }

    public void setLength(long newLen) throws IOException {
        if (newLen < this.length()) {
            this.ch.truncate(newLen);
        } else if (newLen > this.length()) {
            long pos = this.getFilePointer();
            this.seek(newLen - 1L);
            this.write(0);
            this.seek(pos);
        }
    }

    public long length() throws IOException {
        return this.ch.size();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.in.read(buffer);
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        return this.in.read(buffer, offset, len);
    }

    public final boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.in.readByte();
    }

    public final char readChar() throws IOException {
        return this.in.readChar();
    }

    public final double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public final float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public final void readFully(byte[] buffer) throws IOException {
        this.in.readFully(buffer);
    }

    public final void readFully(byte[] buffer, int offset, int count) throws IOException {
        this.in.readFully(buffer, offset, count);
    }

    public final int readInt() throws IOException {
        return this.in.readInt();
    }

    public final String readLine() throws IOException {
        return this.in.readLine();
    }

    public final long readLong() throws IOException {
        return this.in.readLong();
    }

    public final short readShort() throws IOException {
        return this.in.readShort();
    }

    public final int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public final int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final String readUTF() throws IOException {
        return this.in.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.ch.position(pos);
    }

    public int skipBytes(int numBytes) throws IOException {
        long size;
        if (numBytes < 0) {
            throw new IllegalArgumentException("Can't skip negative bytes: " + numBytes);
        }
        if (numBytes == 0) {
            return 0;
        }
        long oldPos = this.ch.position();
        long newPos = oldPos + (long)numBytes;
        if (newPos > (size = this.ch.size())) {
            newPos = size;
        }
        this.ch.position(newPos);
        return (int)(this.ch.position() - oldPos);
    }

    public void write(int oneByte) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.write(oneByte);
    }

    public void write(byte[] buffer) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.write(buffer);
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.write(buffer, offset, len);
    }

    public final void writeBoolean(boolean val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeBoolean(val);
    }

    public final void writeByte(int val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeByte(val);
    }

    public final void writeShort(int val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeShort(val);
    }

    public final void writeChar(int val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeChar(val);
    }

    public final void writeInt(int val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeInt(val);
    }

    public final void writeLong(long val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeLong(val);
    }

    public final void writeFloat(float val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeFloat(val);
    }

    public final void writeDouble(double val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeDouble(val);
    }

    public final void writeBytes(String val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeBytes(val);
    }

    public final void writeChars(String val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeChars(val);
    }

    public final void writeUTF(String val) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeUTF(val);
    }

    public final synchronized FileChannel getChannel() {
        return this.ch;
    }
}

