/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.javax.swing.tree.GnuPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

public class BasicTreeUI
extends TreeUI {
    static int WAIT_TILL_EDITING = 900;
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected Dimension preferredMinSize;
    protected boolean validCachedPreferredSize = false;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> drawingCache = new Hashtable();
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions = this.createNodeDimensions();
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    boolean isEditing;
    TreePath currentVisiblePath;
    int gap = 4;
    int maxHeight;
    Color hashColor;
    PropertyChangeListener propertyChangeListener;
    FocusListener focusListener;
    TreeSelectionListener treeSelectionListener;
    MouseListener mouseListener;
    KeyListener keyListener;
    PropertyChangeListener selectionModelPropertyChangeListener;
    ComponentListener componentListener;
    CellEditorListener cellEditorListener;
    TreeExpansionListener treeExpansionListener;
    TreeModelListener treeModelListener;
    static Icon nullIcon;

    public BasicTreeUI() {
        this.configureLayoutCache();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int newAmount) {
        this.leftChildIndent = newAmount;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int newAmount) {
        this.rightChildIndent = newAmount;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon newG) {
        this.expandedIcon = newG;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon newG) {
        this.collapsedIcon = newG;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean largeModel) {
        if (largeModel != this.largeModel) {
            this.completeEditing();
            this.tree.removeComponentListener(this.componentListener);
            this.largeModel = largeModel;
            this.tree.addComponentListener(this.componentListener);
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int rowHeight) {
        this.completeEditing();
        if (rowHeight == 0) {
            rowHeight = this.getMaxHeight(this.tree);
        }
        this.treeState.setRowHeight(rowHeight);
    }

    protected int getRowHeight() {
        return this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer tcr) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        if (this.currentCellRenderer != null) {
            return this.currentCellRenderer;
        }
        return this.createDefaultCellRenderer();
    }

    protected void setModel(TreeModel model) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = this.tree.getModel();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(this.treeModel);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean newValue) {
        this.completeEditing();
        this.tree.setRootVisible(newValue);
    }

    protected boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    protected void setShowsRootHandles(boolean newValue) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    protected void setCellEditor(TreeCellEditor editor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    protected void setEditable(boolean newValue) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree.isEditable();
    }

    protected void setSelectionModel(TreeSelectionModel newLSM) {
        this.completeEditing();
        if (newLSM != null) {
            this.treeSelectionModel = newLSM;
            this.tree.setSelectionModel(this.treeSelectionModel);
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree tree, TreePath path) {
        Rectangle bounds = null;
        if (tree != null && this.treeState != null) {
            bounds = this.treeState.getBounds(path, null);
            Insets i = tree.getInsets();
            if (bounds != null && i != null) {
                bounds.x += i.left;
                bounds.y += i.top;
            }
        }
        return bounds;
    }

    int getMaxHeight(JTree tree) {
        if (this.maxHeight != 0) {
            return this.maxHeight;
        }
        Icon e = UIManager.getIcon("Tree.openIcon");
        Icon c = UIManager.getIcon("Tree.closedIcon");
        Icon l = UIManager.getIcon("Tree.leafIcon");
        int rc = this.getRowCount(tree);
        int iconHeight = 0;
        int row = 0;
        while (row < rc) {
            iconHeight = this.isLeaf(row) ? l.getIconHeight() : (tree.isExpanded(row) ? e.getIconHeight() : c.getIconHeight());
            this.maxHeight = Math.max(this.maxHeight, iconHeight + this.gap);
            ++row;
        }
        this.treeState.setRowHeight(this.maxHeight);
        return this.maxHeight;
    }

    Icon getNodeIcon(TreePath path) {
        Object node2 = path.getLastPathComponent();
        if (this.treeModel.isLeaf(node2)) {
            return UIManager.getIcon("Tree.leafIcon");
        }
        if (this.treeState.getExpandedState(path)) {
            return UIManager.getIcon("Tree.openIcon");
        }
        return UIManager.getIcon("Tree.closedIcon");
    }

    public TreePath getPathForRow(JTree tree, int row) {
        return this.treeState.getPathForRow(row);
    }

    public int getRowForPath(JTree tree, TreePath path) {
        return this.treeState.getRowForPath(path);
    }

    public int getRowCount(JTree tree) {
        return this.treeState.getRowCount();
    }

    public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
        return this.treeState.getPathClosestTo(x, y);
    }

    public boolean isEditing(JTree tree) {
        return this.isEditing;
    }

    public boolean stopEditing(JTree tree) {
        boolean ret = false;
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            ret = true;
        }
        return ret;
    }

    public void cancelEditing(JTree tree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree tree, TreePath path) {
        tree.scrollPathToVisible(path);
        if (path != null && tree.isVisible(path)) {
            this.startEditing(path, null);
        }
    }

    public TreePath getEditingPath(JTree tree) {
        return this.editingPath;
    }

    protected void prepareForUIInstall() {
        this.lastSelectedRow = -1;
        this.preferredSize = new Dimension();
        this.largeModel = this.tree.isLargeModel();
        this.preferredSize = new Dimension();
        this.stopEditingInCompleteEditing = true;
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.configureLayoutCache();
        this.treeState.setRootVisible(this.tree.isRootVisible());
        this.treeSelectionModel.setRowMapper(this.treeState);
        this.updateSize();
    }

    protected void completeUIUninstall() {
        this.tree = null;
    }

    protected void installComponents() {
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        DefaultTreeCellEditor ed = this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer ? new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer) : new DefaultTreeCellEditor(this.tree, null);
        return ed;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected void uninstallListeners() {
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor tce = this.tree.getCellEditor();
        if (tce != null) {
            tce.removeCellEditorListener(this.cellEditorListener);
        }
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    protected void uninstallKeyboardActions() {
        this.tree.getInputMap(1).setParent(null);
        this.tree.getActionMap().setParent(null);
    }

    protected void uninstallComponents() {
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.createdRenderer = false;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected int getVerticalLegBuffer() {
        return this.getRowHeight() / 2;
    }

    protected int getHorizontalLegBuffer() {
        return this.rightChildIndent / 2;
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath path) {
        this.completeEditing();
        Enumeration<TreePath> expanded = this.tree.getExpandedDescendants(path);
        while (expanded.hasMoreElements()) {
            this.treeState.setExpandedState(expanded.nextElement(), true);
        }
    }

    protected TreePath getLastChildPath(TreePath parent) {
        return (TreePath)parent.getLastPathComponent();
    }

    protected void updateDepthOffset() {
        this.depthOffset += this.getVerticalLegBuffer();
    }

    protected void updateCellEditor() {
        this.completeEditing();
        TreeCellEditor newEd = null;
        if (this.tree != null && this.tree.isEditable() && (newEd = this.tree.getCellEditor()) == null && (newEd = this.createDefaultCellEditor()) != null) {
            this.tree.setCellEditor(newEd);
            this.createdCellEditor = true;
        }
        if (newEd != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = newEd;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer rend = this.tree.getCellRenderer();
            if (rend != null) {
                this.createdRenderer = false;
                this.currentCellRenderer = rend;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            } else {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            }
        } else {
            this.currentCellRenderer = null;
            this.createdRenderer = false;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        this.treeState = this.createLayoutCache();
        this.treeState.setNodeDimensions(this.nodeDimensions);
    }

    protected void updateSize() {
        this.preferredSize = null;
        this.updateCachedPreferredSize();
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        this.validCachedPreferredSize = false;
    }

    protected void pathWasExpanded(TreePath path) {
        this.validCachedPreferredSize = false;
        this.treeState.setExpandedState(path, true);
        this.tree.repaint();
    }

    protected void pathWasCollapsed(TreePath path) {
        this.validCachedPreferredSize = false;
        this.treeState.setExpandedState(path, false);
        this.tree.repaint();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tree, "Tree.background", "Tree.foreground", "Tree.font");
        this.hashColor = UIManager.getColor("Tree.hash");
        if (this.hashColor == null) {
            this.hashColor = Color.black;
        }
        this.tree.setOpaque(true);
        this.rightChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.leftChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.totalChildIndent = this.rightChildIndent + this.leftChildIndent;
        this.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(this.getRowHeight());
        this.tree.setScrollsOnExpand(UIManager.getBoolean("Tree.scrollsOnExpand"));
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
    }

    protected void installKeyboardActions() {
        InputMap focusInputMap = (InputMap)SharedUIDefaults.get("Tree.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.tree, 0, focusInputMap);
        InputMap ancestorInputMap = (InputMap)SharedUIDefaults.get("Tree.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.tree, 1, ancestorInputMap);
        SwingUtilities.replaceUIActionMap(this.tree, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap am = (ActionMap)UIManager.get("Tree.actionMap");
        if (am == null) {
            am = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("Tree.actionMap", am);
        }
        return am;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        AbstractAction action = new TreeHomeAction(-1, "selectFirst");
        am.put(action.getValue("Name"), action);
        action = new TreeHomeAction(-1, "selectFirstChangeLead");
        am.put(action.getValue("Name"), action);
        action = new TreeHomeAction(-1, "selectFirstExtendSelection");
        am.put(action.getValue("Name"), action);
        action = new TreeHomeAction(1, "selectLast");
        am.put(action.getValue("Name"), action);
        action = new TreeHomeAction(1, "selectLastChangeLead");
        am.put(action.getValue("Name"), action);
        action = new TreeHomeAction(1, "selectLastExtendSelection");
        am.put(action.getValue("Name"), action);
        action = new TreeIncrementAction(-1, "selectPrevious");
        am.put(action.getValue("Name"), action);
        action = new TreeIncrementAction(-1, "selectPreviousExtendSelection");
        am.put(action.getValue("Name"), action);
        action = new TreeIncrementAction(-1, "selectPreviousChangeLead");
        am.put(action.getValue("Name"), action);
        action = new TreeIncrementAction(1, "selectNext");
        am.put(action.getValue("Name"), action);
        action = new TreeIncrementAction(1, "selectNextExtendSelection");
        am.put(action.getValue("Name"), action);
        action = new TreeIncrementAction(1, "selectNextChangeLead");
        am.put(action.getValue("Name"), action);
        action = new TreeTraverseAction(-1, "selectParent");
        am.put(action.getValue("Name"), action);
        action = new TreeTraverseAction(1, "selectChild");
        am.put(action.getValue("Name"), action);
        action = new TreeToggleAction("toggleAndAnchor");
        am.put(action.getValue("Name"), action);
        action = new TreePageAction(-1, "scrollUpChangeSelection");
        am.put(action.getValue("Name"), action);
        action = new TreePageAction(-1, "scrollUpExtendSelection");
        am.put(action.getValue("Name"), action);
        action = new TreePageAction(-1, "scrollUpChangeLead");
        am.put(action.getValue("Name"), action);
        action = new TreePageAction(1, "scrollDownChangeSelection");
        am.put(action.getValue("Name"), action);
        action = new TreePageAction(1, "scrollDownExtendSelection");
        am.put(action.getValue("Name"), action);
        action = new TreePageAction(1, "scrollDownChangeLead");
        am.put(action.getValue("Name"), action);
        action = new TreeStartEditingAction("startEditing");
        am.put(action.getValue("Name"), action);
        action = new TreeCancelEditingAction("cancel");
        am.put(action.getValue("Name"), action);
        return am;
    }

    private int convertModifiers(int mod) {
        if ((mod & 0x40) != 0) {
            mod |= 1;
            mod &= 0xFFFFFFBF;
        }
        if ((mod & 0x80) != 0) {
            mod |= 2;
            mod &= 0xFFFFFF7F;
        }
        if ((mod & 0x100) != 0) {
            mod |= 4;
            mod &= 0xFFFFFEFF;
        }
        if ((mod & 0x200) != 0) {
            mod |= 8;
            mod &= 0xFFFFFDFF;
        }
        if ((mod & 0x2000) != 0) {
            mod |= 0x20;
            mod &= 0xFFFFDFFF;
        }
        return mod;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.tree.addFocusListener(this.focusListener);
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.mouseListener = this.createMouseListener();
        this.tree.addMouseListener(this.mouseListener);
        this.keyListener = this.createKeyListener();
        this.tree.addKeyListener(this.keyListener);
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        if (this.treeSelectionModel != null && this.selectionModelPropertyChangeListener != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        this.componentListener = this.createComponentListener();
        this.tree.addComponentListener(this.componentListener);
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        this.treeModelListener = this.createTreeModelListener();
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        this.cellEditorListener = this.createCellEditorListener();
    }

    public void installUI(JComponent c) {
        this.tree = (JTree)c;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
        this.completeUIInstall();
    }

    protected void uninstallDefaults() {
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
    }

    public void uninstallUI(JComponent c) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    public void paint(Graphics g, JComponent c) {
        JTree tree = (JTree)c;
        int rows = this.treeState.getRowCount();
        if (rows == 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Insets insets = tree.getInsets();
        if (clip != null && this.treeModel != null) {
            int startIndex = tree.getClosestRowForLocation(clip.x, clip.y);
            int endIndex = tree.getClosestRowForLocation(clip.x + clip.width, clip.y + clip.height);
            if (endIndex < rows) {
                int i = endIndex + 1;
                while (i < rows) {
                    TreePath path = this.treeState.getPathForRow(i);
                    if (this.isLastChild(path)) {
                        this.paintVerticalPartOfLeg(g, clip, insets, path);
                    }
                    ++i;
                }
            }
            int n = endIndex - startIndex + 1;
            Rectangle[] bounds = new Rectangle[n];
            boolean[] isLeaf = new boolean[n];
            boolean[] isExpanded = new boolean[n];
            TreePath[] path = new TreePath[n];
            int k = 0;
            int i = startIndex;
            while (i <= endIndex) {
                path[k] = this.treeState.getPathForRow(i);
                if (path[k] != null) {
                    isLeaf[k] = this.treeModel.isLeaf(path[k].getLastPathComponent());
                    isExpanded[k] = tree.isExpanded(path[k]);
                    bounds[k] = this.getPathBounds(tree, path[k]);
                    this.paintHorizontalPartOfLeg(g, clip, insets, bounds[k], path[k], i, isExpanded[k], false, isLeaf[k]);
                }
                if (this.isLastChild(path[k])) {
                    this.paintVerticalPartOfLeg(g, clip, insets, path[k]);
                }
                ++i;
                ++k;
            }
            k = 0;
            i = startIndex;
            while (i <= endIndex) {
                if (path[k] != null) {
                    this.paintRow(g, clip, insets, bounds[k], path[k], i, isExpanded[k], false, isLeaf[k]);
                }
                ++i;
                ++k;
            }
        }
    }

    private boolean isLastChild(TreePath path) {
        if (path == null) {
            return false;
        }
        if (path instanceof GnuPath) {
            return ((GnuPath)path).isLastChild;
        }
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return false;
        }
        int childCount = this.treeState.getVisibleChildCount(parent);
        int p = this.treeModel.getIndexOfChild(parent, path.getLastPathComponent());
        return p == childCount - 1;
    }

    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        if (beginRow < endRow) {
            int temp = endRow;
            endRow = beginRow;
            beginRow = temp;
        }
        int i = beginRow;
        while (i < endRow) {
            TreePath path = this.getPathForRow(this.tree, i);
            if (!this.tree.isVisible(path)) {
                this.tree.makeVisible(path);
            }
            ++i;
        }
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return this.getPreferredSize(this.tree);
        }
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredSize(c, false);
    }

    public Dimension getPreferredSize(JComponent c, boolean checkConsistancy) {
        if (!this.validCachedPreferredSize) {
            Rectangle size = this.tree.getBounds();
            this.preferredSize = new Dimension(this.treeState.getPreferredWidth(size), this.treeState.getPreferredHeight());
            this.validCachedPreferredSize = true;
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        this.preferredMinSize = this.getPreferredSize(c);
        return this.preferredMinSize;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageTree) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component comp = this.editingComponent;
            TreePath p = this.editingPath;
            this.editingComponent = null;
            this.editingPath = null;
            if (messageStop) {
                this.cellEditor.stopCellEditing();
            } else if (messageCancel) {
                this.cellEditor.cancelCellEditing();
            }
            this.tree.remove(comp);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(p);
                this.updateSize();
            } else {
                Rectangle b = this.getPathBounds(this.tree, p);
                this.tree.repaint(0, b.y, this.tree.getWidth(), b.height);
            }
            if (messageTree) {
                Object value = this.cellEditor.getCellEditorValue();
                this.treeModel.valueForPathChanged(p, value);
            }
        }
    }

    protected boolean startEditing(TreePath path, MouseEvent event) {
        if (this.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.stopEditing(this.tree)) {
            return false;
        }
        this.completeEditing();
        TreeCellEditor ed = this.cellEditor;
        if (ed != null && this.tree.isPathEditable(path)) {
            if (ed.isCellEditable(event)) {
                this.editingRow = this.getRowForPath(this.tree, path);
                Object value = path.getLastPathComponent();
                boolean isSelected = this.tree.isPathSelected(path);
                boolean isExpanded = this.tree.isExpanded(this.editingPath);
                boolean isLeaf = this.treeModel.isLeaf(value);
                this.editingComponent = ed.getTreeCellEditorComponent(this.tree, value, isSelected, isExpanded, isLeaf, this.editingRow);
                Rectangle bounds = this.getPathBounds(this.tree, path);
                Dimension size = this.editingComponent.getPreferredSize();
                int rowHeight = this.getRowHeight();
                if (size.height != bounds.height && rowHeight > 0) {
                    size.height = rowHeight;
                }
                if (size.width != bounds.width || size.height != bounds.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(path);
                    this.updateSize();
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(bounds.x, bounds.y, size.width, size.height);
                this.editingComponent.validate();
                this.editingPath = path;
                if (ed.shouldSelectCell(event)) {
                    this.stopEditingInCompleteEditing = false;
                    this.tree.setSelectionRow(this.editingRow);
                    this.stopEditingInCompleteEditing = true;
                }
                this.editorRequestFocus(this.editingComponent);
                if (event instanceof MouseEvent) {
                    Point p = SwingUtilities.convertPoint(this.tree, event.getX(), event.getY(), this.editingComponent);
                    Component active = SwingUtilities.getDeepestComponentAt(this.editingComponent, p.x, p.y);
                    if (active != null) {
                        new MouseInputHandler(this.tree, active, event);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    private void editorRequestFocus(Component c) {
        if (c instanceof Container) {
            Container cont = (Container)c;
            if (cont.getComponentCount() > 0) {
                cont.getComponent(0).requestFocus();
            }
        } else if (c.isFocusable()) {
            c.requestFocus();
        }
    }

    protected void checkForClickInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (this.isLocationInExpandControl(path, mouseX, mouseY)) {
            this.handleExpandControlClick(path, mouseX, mouseY);
        }
    }

    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        boolean cntlClick = false;
        if (!this.treeModel.isLeaf(path.getLastPathComponent())) {
            Icon expandedIcon = this.getExpandedIcon();
            int width = expandedIcon != null ? expandedIcon.getIconWidth() : 18;
            Insets i = this.tree.getInsets();
            int depth = this.isRootVisible() ? path.getPathCount() - 1 : path.getPathCount() - 2;
            int left = this.getRowX(this.tree.getRowForPath(path), depth) - width + i.left;
            cntlClick = mouseX >= left && mouseX <= left + width;
        }
        return cntlClick;
    }

    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        this.toggleExpandState(path);
    }

    protected void toggleExpandState(TreePath path) {
        if (this.treeState.isExpanded(path)) {
            this.tree.collapsePath(path);
        } else {
            this.tree.expandPath(path);
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return this.tree.getSelectionModel().getSelectionMode() != 1 && (event.getModifiersEx() & 0x80) != 0;
    }

    protected boolean isMultiSelectEvent(MouseEvent event) {
        return this.tree.getSelectionModel().getSelectionMode() != 1 && (event.getModifiersEx() & 0x40) != 0;
    }

    protected boolean isToggleEvent(MouseEvent event) {
        int clickCount;
        boolean toggle = false;
        if (SwingUtilities.isLeftMouseButton(event) && (clickCount = this.tree.getToggleClickCount()) > 0 && event.getClickCount() == clickCount) {
            toggle = true;
        }
        return toggle;
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (this.isToggleSelectionEvent(event)) {
            if (this.tree.isPathSelected(path)) {
                this.tree.removeSelectionPath(path);
            } else {
                this.tree.addSelectionPath(path);
                this.tree.setAnchorSelectionPath(path);
            }
        } else if (this.isMultiSelectEvent(event)) {
            TreePath anchor = this.tree.getAnchorSelectionPath();
            if (anchor != null) {
                int aRow = this.getRowForPath(this.tree, anchor);
                this.tree.addSelectionInterval(aRow, this.getRowForPath(this.tree, path));
            } else {
                this.tree.addSelectionPath(path);
            }
        } else {
            this.tree.setSelectionPath(path);
            if (this.isToggleEvent(event)) {
                this.toggleExpandState(path);
            }
        }
    }

    protected boolean isLeaf(int row) {
        TreePath pathForRow = this.getPathForRow(this.tree, row);
        if (pathForRow == null) {
            return true;
        }
        Object node2 = pathForRow.getLastPathComponent();
        return this.treeModel.isLeaf(node2);
    }

    boolean hasControlIcons() {
        return this.expandedIcon != null || this.collapsedIcon != null;
    }

    Icon getCurrentControlIcon(TreePath path) {
        if (this.hasControlIcons()) {
            if (this.tree.isExpanded(path)) {
                return this.expandedIcon;
            }
            return this.collapsedIcon;
        }
        if (nullIcon == null) {
            nullIcon = new Icon(){

                public int getIconHeight() {
                    return 0;
                }

                public int getIconWidth() {
                    return 0;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
        }
        return nullIcon;
    }

    Object getParent(Object root, Object node2) {
        if (root == null || node2 == null || root.equals(node2)) {
            return null;
        }
        if (node2 instanceof TreeNode) {
            return ((TreeNode)node2).getParent();
        }
        return this.findNode(root, node2);
    }

    private Object findNode(Object root, Object node2) {
        if (!this.treeModel.isLeaf(root) && !root.equals(node2)) {
            int size = this.treeModel.getChildCount(root);
            int j = 0;
            while (j < size) {
                Object child = this.treeModel.getChild(root, j);
                if (node2.equals(child)) {
                    return root;
                }
                Object n = this.findNode(child, node2);
                if (n != null) {
                    return n;
                }
                ++j;
            }
        }
        return null;
    }

    void selectPath(JTree tree, TreePath path) {
        if (path != null) {
            tree.setSelectionPath(path);
            tree.setLeadSelectionPath(path);
            tree.makeVisible(path);
            tree.scrollPathToVisible(path);
        }
    }

    Object[] getPathToRoot(Object node2, int depth) {
        if (node2 == null) {
            if (depth == 0) {
                return null;
            }
            return new Object[depth];
        }
        Object[] path = this.getPathToRoot(this.getParent(this.treeModel.getRoot(), node2), depth + 1);
        path[path.length - depth - 1] = node2;
        return path;
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        g.setColor(this.getHashColor());
        g.drawLine(x, top, x, bottom);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        g.setColor(this.getHashColor());
        g.drawLine(left, y, right, y);
    }

    protected void drawCentered(Component c, Graphics g, Icon icon, int x, int y) {
        y -= icon.getIconHeight() / 2;
        if ((x -= icon.getIconWidth() / 2) < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        icon.paintIcon(c, g, x, y);
    }

    protected void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
        g.setColor(this.getHashColor());
        int i = x1;
        while (i < x2) {
            g.drawLine(i, y, i + 1, y);
            i += 2;
        }
    }

    protected void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
        g.setColor(this.getHashColor());
        int i = y1;
        while (i < y2) {
            g.drawLine(x, i, x, i + 1);
            i += 2;
        }
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            Icon icon = this.getCurrentControlIcon(path);
            int iconW = icon.getIconWidth();
            int x = bounds.x - iconW - this.gap;
            icon.paintIcon(this.tree, g, x, bounds.y + bounds.height / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (row != 0) {
            this.paintHorizontalLine(g, this.tree, bounds.y + bounds.height / 2, bounds.x - this.leftChildIndent - this.gap, bounds.x - this.gap);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        boolean paintLine;
        Rectangle bounds = this.getPathBounds(this.tree, path);
        TreePath parent = path.getParentPath();
        if (this.isRootVisible()) {
            paintLine = parent != null;
        } else {
            boolean bl = paintLine = parent != null && parent.getPathCount() > 1;
        }
        if (paintLine) {
            Rectangle parentBounds = this.getPathBounds(this.tree, parent);
            this.paintVerticalLine(g, this.tree, parentBounds.x + 2 * this.gap, parentBounds.y + parentBounds.height / 2, bounds.y + bounds.height / 2);
        }
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean selected = this.tree.isPathSelected(path);
        Object node2 = path.getLastPathComponent();
        this.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        TreeCellRenderer dtcr = this.currentCellRenderer;
        boolean focused = false;
        if (this.treeSelectionModel != null) {
            focused = this.treeSelectionModel.getLeadSelectionRow() == row && this.tree.isFocusOwner();
        }
        Component c = dtcr.getTreeCellRendererComponent(this.tree, node2, selected, isExpanded, isLeaf, row, focused);
        this.rendererPane.paintComponent(g, c, c.getParent(), bounds);
    }

    protected void prepareForUIUninstall() {
    }

    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        path.getLastPathComponent();
        return !isLeaf && this.hasControlIcons();
    }

    protected int getRowX(int row, int depth) {
        return depth * this.totalChildIndent;
    }

    public class CellEditorHandler
    implements CellEditorListener {
        public void editingStopped(ChangeEvent e) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent e) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = this.getScrollPane();
                if (scrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            JScrollPane found = null;
            Container p = BasicTreeUI.this.tree.getParent();
            while (p != null && !(p instanceof JScrollPane)) {
                p = p.getParent();
            }
            if (p instanceof JScrollPane) {
                found = (JScrollPane)p;
            }
            return found;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            this.repaintLeadRow();
        }

        public void focusLost(FocusEvent e) {
            this.repaintLeadRow();
        }

        void repaintLeadRow() {
            TreePath lead = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (lead != null) {
                BasicTreeUI.this.tree.repaint(BasicTreeUI.this.tree.getPathBounds(lead));
            }
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyTyped(KeyEvent e) {
            char typed = Character.toLowerCase(e.getKeyChar());
            int row = BasicTreeUI.this.tree.getLeadSelectionRow() + 1;
            while (row < BasicTreeUI.this.tree.getRowCount()) {
                if (this.checkMatch(row, typed)) {
                    BasicTreeUI.this.tree.setSelectionRow(row);
                    BasicTreeUI.this.tree.scrollRowToVisible(row);
                    return;
                }
                ++row;
            }
            row = 0;
            while (row < BasicTreeUI.this.tree.getLeadSelectionRow()) {
                if (this.checkMatch(row, typed)) {
                    BasicTreeUI.this.tree.setSelectionRow(row);
                    BasicTreeUI.this.tree.scrollRowToVisible(row);
                    return;
                }
                ++row;
            }
        }

        boolean checkMatch(int row, char typed) {
            char x;
            TreePath path = BasicTreeUI.this.treeState.getPathForRow(row);
            String node2 = path.getLastPathComponent().toString();
            return node2.length() > 0 && typed == Character.toLowerCase(x = node2.charAt(0));
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean selectedOnPress;

        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                this.handleEvent(e);
                this.selectedOnPress = true;
            } else {
                this.selectedOnPress = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed() && !this.selectedOnPress) {
                this.handleEvent(e);
            }
        }

        private void handleEvent(MouseEvent e) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                    return;
                }
                BasicTreeUI.this.tree.requestFocusInWindow();
                int x = e.getX();
                int y = e.getY();
                TreePath path = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, x, y);
                if (path != null) {
                    Rectangle b = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, path);
                    if (y <= b.y + b.height) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            BasicTreeUI.this.checkForClickInExpandControl(path, x, y);
                        }
                        if (x > b.x && x <= b.x + b.width && !BasicTreeUI.this.startEditing(path, e)) {
                            BasicTreeUI.this.selectPathForEvent(path, e);
                        }
                    }
                }
            }
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component source, Component destination, MouseEvent e) {
            this.source = source;
            this.destination = destination;
            source.addMouseListener(this);
            source.addMouseMotionListener(this);
            this.dispatch(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.dispatch(e);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.dispatch(e);
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.dispatch(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.source = null;
            this.destination = null;
        }

        private void dispatch(MouseEvent e) {
            if (this.destination != null) {
                MouseEvent e2 = SwingUtilities.convertMouseEvent(this.source, e, this.destination);
                this.destination.dispatchEvent(e2);
            }
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object cell, int row, int depth, boolean expanded, Rectangle size) {
            Dimension prefSize;
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == row) {
                prefSize = BasicTreeUI.this.editingComponent.getPreferredSize();
                int rowHeight = BasicTreeUI.this.getRowHeight();
                if (rowHeight > 0 && rowHeight != prefSize.height) {
                    prefSize.height = rowHeight;
                }
            } else {
                Component rend = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, cell, BasicTreeUI.this.tree.isRowSelected(row), expanded, BasicTreeUI.this.treeModel.isLeaf(cell), row, false);
                BasicTreeUI.this.rendererPane.add(rend);
                rend.validate();
                prefSize = rend.getPreferredSize();
            }
            if (size != null) {
                size.x = this.getRowX(row, depth);
                size.y = prefSize.height * row;
                size.width = prefSize.width;
                size.height = prefSize.height;
            } else {
                size = new Rectangle(this.getRowX(row, depth), prefSize.height * row, prefSize.width, prefSize.height);
            }
            return size;
        }

        protected int getRowX(int row, int depth) {
            return BasicTreeUI.this.getRowX(row, depth);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getPropertyName();
            if (property.equals("rootVisible")) {
                BasicTreeUI.this.validCachedPreferredSize = false;
                BasicTreeUI.this.treeState.setRootVisible(BasicTreeUI.this.tree.isRootVisible());
                BasicTreeUI.this.tree.repaint();
            } else if (property.equals("selectionModel")) {
                BasicTreeUI.this.treeSelectionModel = BasicTreeUI.this.tree.getSelectionModel();
                BasicTreeUI.this.treeSelectionModel.setRowMapper(BasicTreeUI.this.treeState);
            } else if (property.equals("model")) {
                BasicTreeUI.this.setModel(BasicTreeUI.this.tree.getModel());
            } else if (property.equals("cellRenderer")) {
                BasicTreeUI.this.setCellRenderer(BasicTreeUI.this.tree.getCellRenderer());
                if (BasicTreeUI.this.treeState != null) {
                    BasicTreeUI.this.treeState.invalidateSizes();
                }
            } else if (property.equals("editable")) {
                BasicTreeUI.this.setEditable((Boolean)event.getNewValue());
            }
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            BasicTreeUI.this.treeSelectionModel.resetRowSelection();
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled() && BasicTreeUI.this.tree.isEditing()) {
                BasicTreeUI.this.tree.cancelEditing();
            }
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent event) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.setExpandedState(event.getPath(), true);
            BasicTreeUI.this.maxHeight = 0;
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            BasicTreeUI.this.completeEditing();
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.setExpandedState(event.getPath(), false);
            BasicTreeUI.this.maxHeight = 0;
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;

        public TreeHomeAction(int dir, String name) {
            this.direction = dir;
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                String command = (String)this.getValue("Name");
                if (command.equals("selectFirst")) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                }
                if (command.equals("selectFirstChangeLead")) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0));
                }
                if (command.equals("selectFirstExtendSelection")) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    TreePath anchorPath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                    if (anchorPath == null) {
                        BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                    } else {
                        int anchorRow = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, anchorPath);
                        BasicTreeUI.this.tree.setSelectionInterval(0, anchorRow);
                        BasicTreeUI.this.tree.setAnchorSelectionPath(anchorPath);
                        BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0));
                    }
                } else if (command.equals("selectLast")) {
                    int end = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) - 1;
                    BasicTreeUI.this.ensureRowsAreVisible(end, end);
                    BasicTreeUI.this.tree.setSelectionInterval(end, end);
                } else if (command.equals("selectLastChangeLead")) {
                    int end = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) - 1;
                    BasicTreeUI.this.ensureRowsAreVisible(end, end);
                    BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, end));
                } else if (command.equals("selectLastExtendSelection")) {
                    int end = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) - 1;
                    BasicTreeUI.this.ensureRowsAreVisible(end, end);
                    TreePath anchorPath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                    if (anchorPath == null) {
                        BasicTreeUI.this.tree.setSelectionInterval(end, end);
                    } else {
                        int anchorRow = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, anchorPath);
                        BasicTreeUI.this.tree.setSelectionInterval(end, anchorRow);
                        BasicTreeUI.this.tree.setAnchorSelectionPath(anchorPath);
                        BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, end));
                    }
                }
            }
            BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;

        public TreeIncrementAction(int dir, String name) {
            this.direction = dir;
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath currentPath = BasicTreeUI.this.tree.getLeadSelectionPath();
            int currentRow = currentPath != null ? BasicTreeUI.this.treeState.getRowForPath(currentPath) : 0;
            int rows = BasicTreeUI.this.treeState.getRowCount();
            int nextRow = currentRow + 1;
            int prevRow = currentRow - 1;
            boolean hasNext = nextRow < rows;
            boolean hasPrev = prevRow >= 0 && rows > 0;
            String command = (String)this.getValue("Name");
            if (command.equals("selectPreviousChangeLead") && hasPrev) {
                TreePath newPath = BasicTreeUI.this.treeState.getPathForRow(prevRow);
                BasicTreeUI.this.tree.setSelectionPath(newPath);
                BasicTreeUI.this.tree.setAnchorSelectionPath(newPath);
                BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
            } else if (command.equals("selectPreviousExtendSelection") && hasPrev) {
                TreePath newPath = BasicTreeUI.this.treeState.getPathForRow(prevRow);
                if (BasicTreeUI.this.tree.isPathSelected(newPath)) {
                    BasicTreeUI.this.tree.getSelectionModel().removeSelectionPath(currentPath);
                }
                BasicTreeUI.this.tree.addSelectionPath(newPath);
                BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
            } else if (command.equals("selectPrevious") && hasPrev) {
                TreePath newPath = BasicTreeUI.this.treeState.getPathForRow(prevRow);
                BasicTreeUI.this.tree.setSelectionPath(newPath);
            } else if (command.equals("selectNext") && hasNext) {
                TreePath newPath = BasicTreeUI.this.treeState.getPathForRow(nextRow);
                BasicTreeUI.this.tree.setSelectionPath(newPath);
            } else if (command.equals("selectNextExtendSelection") && hasNext) {
                TreePath newPath = BasicTreeUI.this.treeState.getPathForRow(nextRow);
                if (BasicTreeUI.this.tree.isPathSelected(newPath)) {
                    BasicTreeUI.this.tree.getSelectionModel().removeSelectionPath(currentPath);
                }
                BasicTreeUI.this.tree.addSelectionPath(newPath);
                BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
            } else if (command.equals("selectNextChangeLead") && hasNext) {
                TreePath newPath = BasicTreeUI.this.treeState.getPathForRow(nextRow);
                BasicTreeUI.this.tree.setSelectionPath(newPath);
                BasicTreeUI.this.tree.setAnchorSelectionPath(newPath);
                BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
            }
            BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeNodesChanged(e);
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeNodesInserted(e);
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeNodesRemoved(e);
            BasicTreeUI.this.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            if (e.getPath().length == 1 && !e.getPath()[0].equals(BasicTreeUI.this.treeModel.getRoot())) {
                BasicTreeUI.this.tree.expandPath(new TreePath(BasicTreeUI.this.treeModel.getRoot()));
            }
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeStructureChanged(e);
            BasicTreeUI.this.tree.repaint();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;

        public TreePageAction(int direction, String name) {
            this.direction = direction;
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount;
            boolean changeSelection;
            String command = (String)this.getValue("Name");
            boolean extendSelection = command.equals("scrollUpExtendSelection") || command.equals("scrollDownExtendSelection");
            boolean bl = changeSelection = command.equals("scrollUpChangeSelection") || command.equals("scrollDownChangeSelection");
            if (!extendSelection && !changeSelection && BasicTreeUI.this.tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                Dimension maxSize = BasicTreeUI.this.tree.getSize();
                TreePath lead = BasicTreeUI.this.tree.getLeadSelectionPath();
                TreePath newPath = null;
                Rectangle visible = BasicTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    newPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, visible.x, visible.y);
                    if (newPath.equals(lead)) {
                        visible.y = Math.max(0, visible.y - visible.height);
                        newPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, visible.x, visible.y);
                    }
                } else {
                    visible.y = Math.min(maxSize.height, visible.y + visible.height - 1);
                    newPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, visible.x, visible.y);
                    if (newPath.equals(lead)) {
                        visible.y = Math.min(maxSize.height, visible.y + visible.height - 1);
                        newPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, visible.x, visible.y);
                    }
                }
                Rectangle newVisible = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, newPath);
                newVisible.x = visible.x;
                newVisible.width = visible.width;
                if (this.direction == -1) {
                    newVisible.height = visible.height;
                } else {
                    newVisible.y -= visible.height - newVisible.height;
                    newVisible.height = visible.height;
                }
                if (extendSelection) {
                    TreePath anchorPath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                    if (anchorPath == null) {
                        BasicTreeUI.this.tree.setSelectionPath(newPath);
                    } else {
                        int newIndex = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, newPath);
                        int anchorIndex = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, anchorPath);
                        BasicTreeUI.this.tree.setSelectionInterval(Math.min(anchorIndex, newIndex), Math.max(anchorIndex, newIndex));
                        BasicTreeUI.this.tree.setAnchorSelectionPath(anchorPath);
                        BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
                    }
                } else if (changeSelection) {
                    BasicTreeUI.this.tree.setSelectionPath(newPath);
                } else {
                    BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(newVisible);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent event) {
            BasicTreeUI.this.completeEditing();
            TreePath op = event.getOldLeadSelectionPath();
            TreePath np = event.getNewLeadSelectionPath();
            if (op != np) {
                Rectangle o = BasicTreeUI.this.treeState.getBounds(event.getOldLeadSelectionPath(), new Rectangle());
                Rectangle n = BasicTreeUI.this.treeState.getBounds(event.getNewLeadSelectionPath(), new Rectangle());
                if (o != null) {
                    BasicTreeUI.this.tree.repaint(o);
                }
                if (n != null) {
                    BasicTreeUI.this.tree.repaint(n);
                }
            }
        }
    }

    class TreeStartEditingAction
    extends AbstractAction {
        public TreeStartEditingAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath lead = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (!BasicTreeUI.this.tree.isEditing()) {
                BasicTreeUI.this.tree.startEditingAtPath(lead);
            }
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String name) {
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            int selected = BasicTreeUI.this.tree.getLeadSelectionRow();
            if (selected != -1 && BasicTreeUI.this.isLeaf(selected)) {
                TreePath anchorPath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                TreePath leadPath = BasicTreeUI.this.tree.getLeadSelectionPath();
                BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, selected));
                BasicTreeUI.this.tree.setLeadSelectionPath(leadPath);
                BasicTreeUI.this.tree.setAnchorSelectionPath(anchorPath);
                BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;

        public TreeTraverseAction(int direction, String name) {
            this.direction = direction;
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath current = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (current == null) {
                return;
            }
            String command = (String)this.getValue("Name");
            if (command.equals("selectParent")) {
                if (current == null) {
                    return;
                }
                if (BasicTreeUI.this.tree.isExpanded(current)) {
                    BasicTreeUI.this.tree.collapsePath(current);
                } else {
                    TreePath parent = current.getParentPath();
                    if (parent != null && (parent.getPathCount() != 1 || BasicTreeUI.this.tree.isRootVisible())) {
                        BasicTreeUI.this.tree.setSelectionPath(parent);
                    }
                }
            } else if (command.equals("selectChild")) {
                Object node2 = current.getLastPathComponent();
                int nc = BasicTreeUI.this.treeModel.getChildCount(node2);
                if (nc == 0 || BasicTreeUI.this.treeState.isExpanded(current)) {
                    int nextRow = BasicTreeUI.this.tree.getLeadSelectionRow() + 1;
                    if (nextRow <= BasicTreeUI.this.tree.getRowCount()) {
                        BasicTreeUI.this.tree.setSelectionRow(nextRow);
                    }
                } else {
                    BasicTreeUI.this.tree.expandPath(current);
                }
            }
            BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }
}

