/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi.CORBA;

import gnu.CORBA.ObjectCreator;
import gnu.CORBA.Poa.AOM;
import gnu.CORBA.Poa.ORB_1_4;
import gnu.CORBA.Poa.gnuPOA;
import gnu.CORBA.typecodes.GeneralTypeCode;
import gnu.classpath.VMStackWalker;
import gnu.javax.rmi.CORBA.DelegateFactory;
import gnu.javax.rmi.CORBA.RmiUtilities;
import gnu.javax.rmi.CORBA.StubDelegateImpl;
import gnu.javax.rmi.CORBA.TieTargetRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnexpectedException;
import java.rmi.server.RMIClassLoader;
import java.util.Hashtable;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class UtilDelegateImpl
extends RmiUtilities
implements UtilDelegate {
    static ValueHandler m_ValueHandler;
    static Hashtable m_Ties;
    static Hashtable m_Targets;
    static final String m_StandardPackage = "org.omg.CORBA.";

    static {
        m_Ties = new Hashtable();
        m_Targets = new Hashtable();
    }

    public java.lang.Object copyObject(java.lang.Object obj, ORB orb) throws RemoteException {
        if (obj instanceof String) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[] || obj instanceof String[][] || obj instanceof String[][][]) {
            return ((java.lang.Object[])obj).clone();
        }
        if (obj instanceof Serializable) {
            try {
                ByteArrayOutputStream a = new ByteArrayOutputStream();
                ObjectOutputStream ou = new ObjectOutputStream(a);
                ou.writeObject(obj);
                ou.close();
                ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(a.toByteArray()));
                return input.readObject();
            }
            catch (Exception exception) {
                RemoteException rex = new RemoteException("Cannot copy " + obj);
                throw rex;
            }
        }
        return obj;
    }

    public java.lang.Object[] copyObjects(java.lang.Object[] obj, ORB orb) throws RemoteException {
        return (java.lang.Object[])this.copyObject(obj, orb);
    }

    public ValueHandler createValueHandler() {
        if (m_ValueHandler == null) {
            m_ValueHandler = (ValueHandler)DelegateFactory.getInstance("ValueHandler");
        }
        return m_ValueHandler;
    }

    public String getCodebase(Class clz) {
        return RMIClassLoader.getClassAnnotation(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tie getTie(Remote target) {
        Hashtable hashtable = m_Targets;
        synchronized (hashtable) {
            Tie tie;
            TieTargetRecord r = (TieTargetRecord)m_Targets.get(target);
            if (r == null) {
                if (target instanceof Stub) {
                    tie = StubDelegateImpl.getTieFromStub(target);
                    this.registerTarget(tie, target);
                } else {
                    String tieClassName = this.getTieClassName(target.getClass().getName());
                    try {
                        Class tieClass = Util.loadClass(tieClassName, null, target.getClass().getClassLoader());
                        tie = (Tie)tieClass.newInstance();
                    }
                    catch (Exception e) {
                        MARSHAL m = new MARSHAL("Unable to instantiate " + tieClassName);
                        m.minor = 1195573274;
                        m.initCause(e);
                        throw m;
                    }
                    tie.setTarget(target);
                    this.registerTarget(tie, target);
                }
            } else {
                tie = r.tie;
            }
            return tie;
        }
    }

    private String getTieClassName(String interf) {
        int p = interf.lastIndexOf(46);
        String stubClassName = p < 0 ? "_" + interf + "_Tie" : String.valueOf(interf.substring(0, p + 1)) + "_" + interf.substring(p + 1) + "_Tie";
        return stubClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTarget(Tie tie, Remote target) {
        Hashtable hashtable = m_Ties;
        synchronized (hashtable) {
            Hashtable hashtable2 = m_Targets;
            synchronized (hashtable2) {
                TieTargetRecord r = (TieTargetRecord)m_Ties.get(tie);
                if (r == null) {
                    r = new TieTargetRecord(tie);
                    m_Ties.put(tie, r);
                }
                if (target != null) {
                    r.add(target);
                    m_Targets.put(target, r);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexportObject(Remote target) throws NoSuchObjectException {
        Hashtable hashtable = m_Ties;
        synchronized (hashtable) {
            Hashtable hashtable2 = m_Targets;
            synchronized (hashtable2) {
                TieTargetRecord r = (TieTargetRecord)m_Targets.get(target);
                if (r != null) {
                    if (target instanceof Object) {
                        r.tie.orb().disconnect((Object)((java.lang.Object)target));
                    }
                    if (r.unused()) {
                        m_Targets.remove(target);
                        m_Ties.remove(r.tie);
                        r.tie.deactivate();
                        if (r.tie.orb() instanceof ORB_1_4) {
                            AOM.Obj record;
                            ORB_1_4 orb = (ORB_1_4)r.tie.orb();
                            if (target instanceof Object && (record = orb.rootPOA.findObject((Object)((java.lang.Object)target))) != null && record.servant == r.tie && record.poa instanceof gnuPOA) {
                                record.poa.aom.remove(record.key);
                                record.deactivated = true;
                                record.servant = null;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        try {
            return stub._is_local();
        }
        catch (SystemException e) {
            RemoteException rex = new RemoteException();
            rex.initCause(e);
            throw rex;
        }
    }

    public Class loadClass(String className, String remoteCodebase, ClassLoader loader) throws ClassNotFoundException {
        String p_useCodebaseOnly;
        boolean useCodebaseOnly;
        if (loader == null) {
            loader = VMStackWalker.firstNonNullClassLoader();
        }
        boolean bl = useCodebaseOnly = (p_useCodebaseOnly = System.getProperty("java.rmi.server.useCodebaseOnly")) != null && p_useCodebaseOnly.trim().equalsIgnoreCase("true");
        if (useCodebaseOnly) {
            remoteCodebase = null;
        }
        try {
            return RMIClassLoader.loadClass(remoteCodebase, className, loader);
        }
        catch (MalformedURLException x) {
            throw new ClassNotFoundException(className, x);
        }
    }

    public RemoteException mapSystemException(SystemException ex) {
        RemoteException rex;
        String status;
        switch (ex.completed.value()) {
            case 2: {
                status = "Maybe";
                break;
            }
            case 1: {
                status = "No";
                break;
            }
            case 0: {
                status = "Yes";
                break;
            }
            default: {
                status = "Unexpected completion status " + ex.completed.value();
            }
        }
        String name = ex.getClass().getName();
        if (name.startsWith(m_StandardPackage)) {
            name = name.substring(m_StandardPackage.length());
        }
        String message = "CORBA " + name + " 0x" + Integer.toHexString(ex.minor) + " " + status;
        if (ex instanceof COMM_FAILURE) {
            rex = new MarshalException(message, ex);
        } else if (ex instanceof INV_OBJREF) {
            rex = new NoSuchObjectException(message);
            rex.detail = ex;
        } else if (ex instanceof NO_PERMISSION) {
            rex = new AccessException(message, ex);
        } else if (ex instanceof MARSHAL) {
            rex = new MarshalException(message, ex);
        } else if (ex instanceof BAD_PARAM) {
            rex = new MarshalException(message, ex);
        } else if (ex instanceof OBJECT_NOT_EXIST) {
            rex = new NoSuchObjectException(message);
            rex.detail = ex;
        } else if (ex instanceof TRANSACTION_REQUIRED) {
            rex = new TransactionRequiredException(message);
            rex.detail = ex;
        } else if (ex instanceof TRANSACTION_ROLLEDBACK) {
            rex = new TransactionRolledbackException(message);
            rex.detail = ex;
        } else if (ex instanceof INVALID_TRANSACTION) {
            rex = new InvalidTransactionException(message);
            rex.detail = ex;
        } else {
            rex = ex instanceof UNKNOWN ? this.wrapException(ex.getCause()) : new RemoteException(message, ex);
        }
        return rex;
    }

    public RemoteException wrapException(Throwable ex) throws RuntimeException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            return new ServerError(ex.getMessage(), (Error)ex);
        }
        if (ex instanceof RemoteException) {
            return new ServerException(ex.getMessage(), (Exception)ex);
        }
        if (ex instanceof SystemException) {
            return this.wrapException(this.mapSystemException((SystemException)ex));
        }
        return new UnexpectedException("Unexpected", (Exception)ex);
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream output, java.lang.Object object) {
        ((OutputStream)output).write_abstract_interface(object);
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream output, java.lang.Object object) {
        boolean inserted;
        Any any = output.orb().create_any();
        if (object == null) {
            GeneralTypeCode t = new GeneralTypeCode(TCKind.tk_abstract_interface);
            t.setId("IDL:omg.org/CORBA/AbstractBase:1.0");
            t.setName("");
            any.type(t);
            output.write_any(any);
            return;
        }
        if (object instanceof Object && !(object instanceof Remote) && (inserted = ObjectCreator.insertWithHelper(any, object))) {
            output.write_any(any);
            return;
        }
        if (object instanceof Object) {
            this.writeAnyAsRemote(output, object);
        } else if (object instanceof Serializable) {
            any.insert_Value((Serializable)object);
            output.write_any(any);
        } else {
            MARSHAL m = new MARSHAL(String.valueOf(object.getClass().getName()) + " must be CORBA Object, Remote or Serializable");
            m.minor = 1195573276;
            throw m;
        }
    }

    void writeAnyAsRemote(org.omg.CORBA.portable.OutputStream output, java.lang.Object object) {
        GeneralTypeCode t = new GeneralTypeCode(TCKind.tk_objref);
        t.setId(m_ValueHandler.getRMIRepositoryID(object.getClass()));
        t.setName(object.getClass().getName());
        output.write_TypeCode(t);
        this.writeRemoteObject(output, object);
    }

    String getName(String n) {
        int p = n.lastIndexOf(46);
        if (p < 0) {
            return n;
        }
        return n.substring(p + 1);
    }

    public java.lang.Object readAny(InputStream input) {
        return input.read_any();
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream an_output, java.lang.Object object) {
        OutputStream output = (OutputStream)an_output;
        if (object == null) {
            an_output.write_Object(null);
        } else if (this.isTieRequired(object)) {
            Class fc = this.getExportedInterface(object);
            this.exportTie(output, object, fc);
        } else if (object instanceof Object) {
            this.ensureOrbRunning(output);
            an_output.write_Object((Object)object);
        } else if (object != null && object instanceof Serializable) {
            this.writeFields(an_output, (Serializable)object);
        }
    }
}

