/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;

public class RMIObjectOutputStream
extends ObjectOutputStream {
    public RMIObjectOutputStream(OutputStream strm) throws IOException {
        super(strm);
        this.enableReplaceObject(true);
    }

    protected void setAnnotation(String annotation) throws IOException {
        this.writeObject(annotation);
    }

    protected void annotateClass(Class cls) throws IOException {
        this.setAnnotation(RMIClassLoader.getClassAnnotation(cls));
    }

    protected void annotateProxyClass(Class cls) throws IOException {
        this.annotateClass(cls);
    }

    protected Object replaceObject(Object obj) throws IOException {
        UnicastServerRef ref;
        if (obj instanceof Remote && !(obj instanceof RemoteStub) && (ref = UnicastServer.getExportedRef((Remote)obj)) != null) {
            return ref.getStub();
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeValue(Object value, Class valueClass) throws IOException {
        if (valueClass.isPrimitive()) {
            if (valueClass == Boolean.TYPE) {
                this.writeBoolean((Boolean)value);
                return;
            } else if (valueClass == Byte.TYPE) {
                this.writeByte(((Byte)value).byteValue());
                return;
            } else if (valueClass == Character.TYPE) {
                this.writeChar(((Character)value).charValue());
                return;
            } else if (valueClass == Short.TYPE) {
                this.writeShort(((Short)value).shortValue());
                return;
            } else if (valueClass == Integer.TYPE) {
                this.writeInt((Integer)value);
                return;
            } else if (valueClass == Long.TYPE) {
                this.writeLong((Long)value);
                return;
            } else if (valueClass == Float.TYPE) {
                this.writeFloat(((Float)value).floatValue());
                return;
            } else {
                if (valueClass != Double.TYPE) throw new Error("Unsupported primitive class: " + valueClass);
                this.writeDouble((Double)value);
            }
            return;
        } else {
            this.writeObject(value);
        }
    }
}

