/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class CombinedClassLoader
extends ClassLoader {
    ClassLoader[] loaders;

    public CombinedClassLoader(Collection a_loaders) {
        ArrayList sLoaders = new ArrayList(a_loaders.size());
        for (Object cl : a_loaders) {
            if (cl == null || sLoaders.contains(cl)) continue;
            sLoaders.add(cl);
        }
        this.loaders = new ClassLoader[sLoaders.size()];
        int i = 0;
        while (i < this.loaders.length) {
            this.loaders[i] = (ClassLoader)sLoaders.get(i);
            ++i;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        int i = 0;
        while (i < this.loaders.length) {
            try {
                return this.loaders[i].loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++i;
            }
        }
        return super.findClass(name);
    }

    protected URL findResource(String name) {
        int i = 0;
        while (i < this.loaders.length) {
            URL resource = this.loaders[i].getResource(name);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return super.findResource(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        int i = 0;
        while (i < this.loaders.length) {
            Enumeration<URL> resource = this.loaders[i].getResources(name);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return super.findResources(name);
    }
}

