/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.javax.crypto.cipher.BaseCipher;
import gnu.javax.crypto.cipher.DES;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class TripleDES
extends BaseCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 24;
    private DES des = new DES();

    public TripleDES() {
        super("tripledes", 8, 24);
    }

    public static void adjustParity(byte[] kb, int offset) {
        TripleDES.adjustParity(3, kb, offset);
    }

    public static void adjustParity(int keyCount, byte[] kb, int offset) {
        if (keyCount < 1 || keyCount > 3) {
            throw new IllegalArgumentException("Invalid keyCount value: " + keyCount);
        }
        DES.adjustParity(kb, offset);
        if (keyCount > 1) {
            DES.adjustParity(kb, offset + 8);
        }
        if (keyCount > 2) {
            DES.adjustParity(kb, offset + 16);
        }
    }

    public static boolean isParityAdjusted(byte[] kb, int offset) {
        return TripleDES.isParityAdjusted(3, kb, offset);
    }

    public static boolean isParityAdjusted(int keyCount, byte[] kb, int offset) {
        if (keyCount < 1 || keyCount > 3) {
            throw new IllegalArgumentException("Invalid keyCount value: " + keyCount);
        }
        boolean result = DES.isParityAdjusted(kb, offset);
        if (keyCount > 1) {
            boolean bl = result = result && DES.isParityAdjusted(kb, offset + 8);
        }
        if (keyCount > 2) {
            result = result && DES.isParityAdjusted(kb, offset + 16);
        }
        return result;
    }

    public Object clone() {
        return new TripleDES();
    }

    public Iterator blockSizes() {
        return Collections.singleton(8).iterator();
    }

    public Iterator keySizes() {
        ArrayList<Integer> al = new ArrayList<Integer>();
        al.add(8);
        al.add(16);
        al.add(24);
        return Collections.unmodifiableList(al).iterator();
    }

    public Object makeKey(byte[] kb, int bs) throws InvalidKeyException {
        if (kb.length != 8 && kb.length != 16 && kb.length != 24) {
            throw new InvalidKeyException("TripleDES key must be 8, 16 or 24 bytes: " + kb.length);
        }
        Context ctx = new Context();
        byte[] k1 = new byte[8];
        System.arraycopy(kb, 0, k1, 0, 8);
        if (!DES.isParityAdjusted(k1, 0)) {
            DES.adjustParity(k1, 0);
        }
        ctx.k1 = (DES.Context)this.des.makeKey(k1, bs);
        if (kb.length == 8) {
            ctx.k2 = (DES.Context)this.des.makeKey(k1, bs);
            ctx.k3 = (DES.Context)this.des.makeKey(k1, bs);
        } else {
            byte[] k2 = new byte[8];
            System.arraycopy(kb, 8, k2, 0, 8);
            if (!DES.isParityAdjusted(k2, 0)) {
                DES.adjustParity(k2, 0);
            }
            ctx.k2 = (DES.Context)this.des.makeKey(k2, bs);
            byte[] k3 = new byte[8];
            if (kb.length == 16) {
                ctx.k3 = (DES.Context)this.des.makeKey(k1, bs);
            } else {
                System.arraycopy(kb, 16, k3, 0, 8);
                if (!DES.isParityAdjusted(k3, 0)) {
                    DES.adjustParity(k3, 0);
                }
                ctx.k3 = (DES.Context)this.des.makeKey(k3, bs);
            }
        }
        return ctx;
    }

    public void encrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        byte[] temp = new byte[8];
        this.des.encrypt(in, i, temp, 0, ((Context)K).k1, bs);
        this.des.decrypt(temp, 0, temp, 0, ((Context)K).k2, bs);
        this.des.encrypt(temp, 0, out, o, ((Context)K).k3, bs);
    }

    public void decrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        byte[] temp = new byte[8];
        this.des.decrypt(in, i, temp, 0, ((Context)K).k3, bs);
        this.des.encrypt(temp, 0, temp, 0, ((Context)K).k2, bs);
        this.des.decrypt(temp, 0, out, o, ((Context)K).k1, bs);
    }

    private final class Context {
        DES.Context k1;
        DES.Context k2;
        DES.Context k3;

        private Context() {
        }
    }
}

