/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.Configuration;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.IntersectingDomainCombiner;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.VMAccessControlState;
import java.util.HashSet;
import java.util.LinkedList;

final class VMAccessController {
    private static final AccessControlContext DEFAULT_CONTEXT;
    private static final boolean DEBUG;

    static {
        CodeSource source = new CodeSource(null, null);
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        ProtectionDomain[] domain = new ProtectionDomain[]{new ProtectionDomain(source, permissions)};
        DEFAULT_CONTEXT = new AccessControlContext(domain);
        DEBUG = Configuration.DEBUG;
    }

    private static void debug(String msg) {
        System.err.print(">>> VMAccessController: ");
        System.err.println(msg);
    }

    private VMAccessController() {
    }

    static void pushContext(AccessControlContext acc) {
        VMAccessControlState state = VMAccessControlState.getThreadState();
        if (state == null) {
            return;
        }
        if (DEBUG) {
            VMAccessController.debug("pushing " + acc);
        }
        LinkedList stack = state.getContexts();
        stack.addFirst(acc);
    }

    static void popContext() {
        LinkedList stack;
        VMAccessControlState state = VMAccessControlState.getThreadState();
        if (state == null) {
            return;
        }
        if (DEBUG) {
            VMAccessController.debug("popping context");
        }
        if (!(stack = state.getContexts()).isEmpty()) {
            stack.removeFirst();
        } else if (DEBUG) {
            VMAccessController.debug("no stack during pop?????");
        }
    }

    static AccessControlContext getContext() {
        DomainCombiner dc;
        VMAccessControlState state = VMAccessControlState.getThreadState();
        if (state == null) {
            return DEFAULT_CONTEXT;
        }
        if (state.isInGetContext()) {
            if (DEBUG) {
                VMAccessController.debug("already in getContext");
            }
            return DEFAULT_CONTEXT;
        }
        state.setInGetContext(true);
        Object[] stack = VMAccessController.getStack();
        Class[] classes = (Class[])stack[0];
        boolean privileged = (Boolean)stack[1];
        if (DEBUG) {
            VMAccessController.debug("got trace of length " + classes.length);
        }
        HashSet<ProtectionDomain> domains = new HashSet<ProtectionDomain>();
        HashSet<ProtectionDomain> seenDomains = new HashSet<ProtectionDomain>();
        AccessControlContext context = null;
        int i = 3;
        while (i < classes.length) {
            ProtectionDomain domain;
            LinkedList l;
            Class clazz = classes[i];
            if (DEBUG) {
                VMAccessController.debug("checking " + clazz);
                VMAccessController.debug("loader = " + clazz.getClassLoader());
            }
            if (privileged && i == classes.length - 2 && !(l = state.getContexts()).isEmpty()) {
                context = (AccessControlContext)l.getFirst();
            }
            if ((domain = clazz.getProtectionDomain()) != null && !seenDomains.contains(domain)) {
                seenDomains.add(domain);
                domains.add(new ProtectionDomain(domain.getCodeSource(), domain.getPermissions()));
            }
            ++i;
        }
        if (DEBUG) {
            VMAccessController.debug("created domains: " + domains);
        }
        ProtectionDomain[] result = domains.toArray(new ProtectionDomain[domains.size()]);
        context = context != null ? ((dc = context.getDomainCombiner()) == null ? new AccessControlContext(IntersectingDomainCombiner.SINGLETON.combine(result, context.getProtectionDomains())) : new AccessControlContext(result, context, dc)) : new AccessControlContext(result);
        state.setInGetContext(false);
        return context;
    }

    private static native Object[] getStack();
}

