/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.Rectangle2D;

public abstract class GraphicAttribute {
    public static final int BOTTOM_ALIGNMENT = -2;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int TOP_ALIGNMENT = -1;
    private int alignment;

    protected GraphicAttribute(int alignment) {
        if (alignment < -2 || alignment > 2) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        this.alignment = alignment;
    }

    public abstract void draw(Graphics2D var1, float var2, float var3);

    public abstract float getAdvance();

    public abstract float getAscent();

    public abstract float getDescent();

    public final int getAlignment() {
        return this.alignment;
    }

    public Rectangle2D getBounds() {
        float asc = this.getAscent();
        return new Rectangle2D.Float(0.0f, -asc, this.getAdvance(), asc + this.getDescent());
    }

    public GlyphJustificationInfo getJustificationInfo() {
        float adv = this.getAdvance();
        return new GlyphJustificationInfo(adv, false, 2, adv / 3.0f, adv / 3.0f, false, 1, 0.0f, 0.0f);
    }
}

