/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class FreetypeGlyphVector
extends GlyphVector {
    private Font font;
    private GdkFontPeer peer;
    private Rectangle2D logicalBounds;
    private float[] glyphPositions;
    private String s;
    private FontRenderContext frc;
    private int nGlyphs;
    private int[] glyphCodes;
    private long[] fontSet = null;
    private AffineTransform[] glyphTransforms;
    private GlyphMetrics[] metricsCache;

    private native void dispose(long[] var1);

    private native long getNativeFontPointer(int var1);

    public FreetypeGlyphVector(Font f, String s, FontRenderContext frc) {
        this(f, s.toCharArray(), 0, s.length(), frc, 0);
    }

    public FreetypeGlyphVector(Font f, char[] chars, int start, int len, FontRenderContext frc, int flags) {
        this.s = new String(chars, start, len);
        this.font = f;
        this.frc = frc;
        if (!(this.font.getPeer() instanceof GdkFontPeer)) {
            throw new IllegalArgumentException("Not a valid font.");
        }
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.getGlyphs();
        if (flags == 1) {
            int[] temp = new int[this.nGlyphs];
            int i = 0;
            while (i < this.nGlyphs) {
                temp[i] = this.glyphCodes[this.nGlyphs - i - 1];
                ++i;
            }
            this.glyphCodes = temp;
        }
        this.performDefaultLayout();
    }

    public FreetypeGlyphVector(Font f, int[] codes, FontRenderContext frc) {
        this.font = f;
        this.frc = frc;
        if (!(this.font.getPeer() instanceof GdkFontPeer)) {
            throw new IllegalArgumentException("Not a valid font.");
        }
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.glyphCodes = new int[codes.length];
        System.arraycopy(codes, 0, this.glyphCodes, 0, codes.length);
        this.nGlyphs = this.glyphCodes.length;
        if (this.fontSet == null) {
            this.fontSet = new long[this.nGlyphs];
            Arrays.fill(this.fontSet, this.getNativeFontPointer(this.nGlyphs));
        }
        this.performDefaultLayout();
    }

    private FreetypeGlyphVector(FreetypeGlyphVector gv) {
        this.font = gv.font;
        this.peer = gv.peer;
        this.frc = gv.frc;
        this.s = gv.s;
        this.nGlyphs = gv.nGlyphs;
        this.logicalBounds = gv.logicalBounds.getBounds2D();
        if (gv.metricsCache != null) {
            this.metricsCache = new GlyphMetrics[this.nGlyphs];
            System.arraycopy(gv.metricsCache, 0, this.metricsCache, 0, this.nGlyphs);
        }
        this.glyphCodes = new int[this.nGlyphs];
        this.fontSet = new long[this.nGlyphs];
        this.glyphPositions = new float[(this.nGlyphs + 1) * 2];
        this.glyphTransforms = new AffineTransform[this.nGlyphs];
        Arrays.fill(this.glyphTransforms, null);
        int i = 0;
        while (i < this.nGlyphs) {
            if (gv.glyphTransforms[i] != null) {
                this.glyphTransforms[i] = new AffineTransform(gv.glyphTransforms[i]);
            }
            this.glyphCodes[i] = gv.glyphCodes[i];
            ++i;
        }
        System.arraycopy(gv.glyphPositions, 0, this.glyphPositions, 0, this.glyphPositions.length);
        System.arraycopy(gv.glyphCodes, 0, this.glyphCodes, 0, this.nGlyphs);
        System.arraycopy(gv.fontSet, 0, this.fontSet, 0, this.nGlyphs);
    }

    public void finalize() {
        this.dispose(this.fontSet);
    }

    private void getGlyphs() {
        this.nGlyphs = this.s.codePointCount(0, this.s.length());
        this.glyphCodes = new int[this.nGlyphs];
        this.fontSet = new long[this.nGlyphs];
        int[] codePoints = new int[this.nGlyphs];
        int stringIndex = 0;
        int i = 0;
        while (i < this.nGlyphs) {
            codePoints[i] = this.s.codePointAt(stringIndex);
            if (codePoints[i] != this.s.charAt(stringIndex)) {
                ++stringIndex;
            }
            ++stringIndex;
            if (Character.isISOControl(codePoints[i])) {
                codePoints[i] = 8202;
            }
            ++i;
        }
        this.getGlyphs(codePoints, this.glyphCodes, this.fontSet);
    }

    public native void getGlyphs(int[] var1, int[] var2, long[] var3);

    private native void getKerning(int var1, int var2, long var3, float[] var5);

    private native double[] getMetricsNative(int var1, long var2);

    private native GeneralPath getGlyphOutlineNative(int var1, long var2);

    public Object clone() {
        return new FreetypeGlyphVector(this);
    }

    public boolean equals(GlyphVector gv) {
        if (!(gv instanceof FreetypeGlyphVector)) {
            return false;
        }
        return ((FreetypeGlyphVector)gv).font.equals(this.font) && ((FreetypeGlyphVector)gv).frc.equals(this.frc) && ((FreetypeGlyphVector)gv).s.equals(this.s);
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.glyphTransforms = new AffineTransform[this.nGlyphs];
        Arrays.fill(this.glyphTransforms, null);
        this.glyphPositions = new float[(this.nGlyphs + 1) * 2];
        GlyphMetrics gm = null;
        float x = 0.0f;
        float y = 0.0f;
        float[] p = new float[]{0.0f, 0.0f};
        int i = 0;
        while (i < this.nGlyphs) {
            gm = this.getGlyphMetrics(i);
            this.glyphPositions[i * 2] = x;
            this.glyphPositions[i * 2 + 1] = y;
            x += gm.getAdvanceX();
            y += gm.getAdvanceY();
            if (i != this.nGlyphs - 1 && this.fontSet[i] == this.fontSet[i + 1]) {
                this.getKerning(this.glyphCodes[i], this.glyphCodes[i + 1], this.fontSet[i], p);
                x += p[0];
                y += p[1];
            }
            ++i;
        }
        this.glyphPositions[this.nGlyphs * 2] = x;
        this.glyphPositions[this.nGlyphs * 2 + 1] = y;
        TransformAttribute ta = (TransformAttribute)this.font.getAttributes().get(TextAttribute.TRANSFORM);
        if (ta != null) {
            AffineTransform tx = ta.getTransform();
            tx.transform(this.glyphPositions, 0, this.glyphPositions, 0, this.glyphPositions.length / 2);
            double[] matrix = new double[4];
            tx.getMatrix(matrix);
            AffineTransform deltaTx = new AffineTransform(matrix);
            if (!deltaTx.isIdentity()) {
                Arrays.fill(this.glyphTransforms, deltaTx);
            }
        }
    }

    public int getGlyphCode(int glyphIndex) {
        return this.glyphCodes[glyphIndex];
    }

    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        int[] rval = codeReturn == null || codeReturn.length < numEntries ? new int[numEntries] : codeReturn;
        System.arraycopy(this.glyphCodes, beginGlyphIndex, rval, 0, numEntries);
        return rval;
    }

    protected long[] getGlyphFonts(int beginGlyphIndex, int numEntries, long[] codeReturn) {
        long[] rval = codeReturn == null || codeReturn.length < numEntries ? new long[numEntries] : codeReturn;
        System.arraycopy(this.fontSet, beginGlyphIndex, rval, 0, numEntries);
        return rval;
    }

    public Shape getGlyphLogicalBounds(int glyphIndex) {
        GlyphMetrics gm = this.getGlyphMetrics(glyphIndex);
        if (gm == null) {
            return null;
        }
        Rectangle2D r = gm.getBounds2D();
        Point2D p = this.getGlyphPosition(glyphIndex);
        double[] bounds = new double[]{p.getX() + r.getX() - (double)gm.getLSB(), p.getY() + r.getY(), p.getX() + r.getX() - (double)gm.getLSB() + (double)gm.getAdvanceX(), p.getY() + r.getY() + r.getHeight()};
        if (this.glyphTransforms[glyphIndex] != null) {
            this.glyphTransforms[glyphIndex].transform(bounds, 0, bounds, 0, 2);
        }
        return new Rectangle2D.Double(bounds[0], bounds[1], bounds[2] - bounds[0], bounds[3] - bounds[1]);
    }

    public void setupGlyphMetrics() {
        this.metricsCache = new GlyphMetrics[this.nGlyphs];
        int i = 0;
        while (i < this.nGlyphs) {
            GlyphMetrics gm = this.peer.getGlyphMetrics(this.glyphCodes[i]);
            if (gm == null) {
                double[] val = this.getMetricsNative(this.glyphCodes[i], this.fontSet[i]);
                if (val == null) {
                    gm = null;
                } else {
                    gm = new GlyphMetrics(true, (float)val[1], (float)val[2], new Rectangle2D.Double(val[3], val[4], val[5], val[6]), 0);
                    this.peer.putGlyphMetrics(this.glyphCodes[i], gm);
                }
            }
            this.metricsCache[i] = gm;
            ++i;
        }
    }

    public GlyphMetrics getGlyphMetrics(int glyphIndex) {
        if (this.metricsCache == null) {
            this.setupGlyphMetrics();
        }
        return this.metricsCache[glyphIndex];
    }

    public Shape getGlyphOutline(int glyphIndex) {
        GeneralPath gp = this.getGlyphOutlineNative(this.glyphCodes[glyphIndex], this.fontSet[glyphIndex]);
        AffineTransform tx = AffineTransform.getTranslateInstance(this.glyphPositions[glyphIndex * 2], this.glyphPositions[glyphIndex * 2 + 1]);
        if (this.glyphTransforms[glyphIndex] != null) {
            tx.concatenate(this.glyphTransforms[glyphIndex]);
        }
        gp.transform(tx);
        return gp;
    }

    public Point2D getGlyphPosition(int glyphIndex) {
        return new Point2D.Float(this.glyphPositions[glyphIndex * 2], this.glyphPositions[glyphIndex * 2 + 1]);
    }

    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        if (positionReturn == null || positionReturn.length < numEntries * 2) {
            positionReturn = new float[numEntries * 2];
        }
        System.arraycopy(this.glyphPositions, beginGlyphIndex * 2, positionReturn, 0, numEntries * 2);
        return positionReturn;
    }

    public AffineTransform getGlyphTransform(int glyphIndex) {
        return this.glyphTransforms[glyphIndex];
    }

    protected boolean hasTransforms() {
        int i = 0;
        while (i < this.glyphTransforms.length) {
            if (this.glyphTransforms[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Shape getGlyphVisualBounds(int glyphIndex) {
        return this.getGlyphOutline(glyphIndex).getBounds2D();
    }

    public Rectangle2D getLogicalBounds() {
        if (this.nGlyphs == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        if (this.logicalBounds != null) {
            return this.logicalBounds;
        }
        Rectangle2D rect = (Rectangle2D)this.getGlyphLogicalBounds(0);
        int i = 1;
        while (i < this.nGlyphs) {
            Rectangle2D r2 = (Rectangle2D)this.getGlyphLogicalBounds(i);
            rect = rect.createUnion(r2);
            ++i;
        }
        this.logicalBounds = rect;
        return rect;
    }

    public int getNumGlyphs() {
        return this.glyphCodes.length;
    }

    public Shape getOutline() {
        GeneralPath path = new GeneralPath();
        int i = 0;
        while (i < this.getNumGlyphs()) {
            path.append(this.getGlyphOutline(i), false);
            ++i;
        }
        return path;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        return null;
    }

    public Shape getOutline(float x, float y) {
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        GeneralPath gp = (GeneralPath)this.getOutline();
        gp.transform(tx);
        return gp;
    }

    public Rectangle2D getVisualBounds() {
        return this.getOutline().getBounds2D();
    }

    public void setGlyphPosition(int glyphIndex, Point2D newPos) {
        this.glyphPositions[glyphIndex * 2] = (float)newPos.getX();
        this.glyphPositions[glyphIndex * 2 + 1] = (float)newPos.getY();
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
        if (newTX != null && newTX.isIdentity()) {
            newTX = null;
        }
        if (this.glyphTransforms[glyphIndex] == null && newTX == null) {
            return;
        }
        if (newTX != null && newTX.equals(this.glyphTransforms[glyphIndex])) {
            return;
        }
        this.logicalBounds = null;
        this.glyphTransforms[glyphIndex] = newTX;
    }
}

