/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class X500PrincipalList
implements Iterable<X500Principal> {
    private final ByteBuffer buffer;
    private int modCount;

    public X500PrincipalList(ByteBuffer buffer) {
        this.buffer = buffer;
        this.modCount = 0;
    }

    public int size() {
        return this.buffer.getShort(0) & 0xFFFF;
    }

    public int count() {
        int size = this.size();
        int i = 0;
        int offset = 2;
        while (offset < size) {
            int _size = this.buffer.getShort(offset) & 0xFFFF;
            if (_size == 0) break;
            offset += _size + 2;
            ++i;
        }
        return i;
    }

    public X500Principal get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index");
        }
        int size = this.size();
        int i = 0;
        int offset = 2;
        while (offset < size) {
            int _size = this.buffer.getShort(offset) & 0xFFFF;
            if (_size == 0) {
                throw new IndexOutOfBoundsException("zero-length name encountered");
            }
            if (i == index) {
                byte[] buf = new byte[_size];
                this.buffer.position(offset + 2);
                this.buffer.get(buf);
                return new X500Principal(buf);
            }
            offset += 2 + _size;
            ++i;
        }
        throw new IndexOutOfBoundsException("limit: " + i + "; requested: " + index);
    }

    public void put(int index, X500Principal principal) {
        this.put(index, principal.getEncoded());
    }

    public void put(int index, byte[] encoded) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index");
        }
        int size = this.size();
        int i = 0;
        int offset = 2;
        while (offset < size) {
            int off = this.buffer.getShort(offset) & 0xFFFF;
            if (i == index) {
                this.buffer.putShort(offset, (short)encoded.length);
                this.buffer.position(offset + 2);
                this.buffer.put(encoded);
                ++this.modCount;
                return;
            }
            offset += 2 + off;
            ++i;
        }
        throw new IndexOutOfBoundsException("limit: " + (i - 1) + "; requested: " + index);
    }

    public void setSize(int numNames, int namesSize) {
        if (numNames < 1) {
            throw new IllegalArgumentException("must have at least one name");
        }
        int size = numNames * 2 + namesSize;
        if (size < 3 || size > this.buffer.capacity() || size > 65535) {
            throw new IllegalArgumentException("size out of range; maximum: " + Math.min(this.buffer.capacity(), 65535));
        }
        this.buffer.putShort(0, (short)size);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("[");
        out.print(this.count());
        out.println("] {");
        Iterator it = new Iterator();
        while (it.hasNext()) {
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  ");
            out.println(it.next());
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("};");
        return str.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof X500PrincipalList)) {
            return false;
        }
        X500PrincipalList that = (X500PrincipalList)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator it1 = new Iterator();
        Iterator it2 = that.new Iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<X500Principal> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<X500Principal> {
        private final int modCount;
        private int index;
        private final int count;

        public Iterator() {
            this.modCount = X500PrincipalList.this.modCount;
            this.index = 0;
            this.count = X500PrincipalList.this.count();
        }

        @Override
        public void add(X500Principal o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public X500Principal next() throws NoSuchElementException {
            if (this.modCount != X500PrincipalList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return X500PrincipalList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public X500Principal previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != X500PrincipalList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return X500PrincipalList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(X500Principal o) {
            throw new UnsupportedOperationException();
        }
    }
}

