/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig;

import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.rsa.RSASignatureFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SignatureFactory {
    private static Set names;

    private SignatureFactory() {
    }

    public static final ISignature getInstance(String ssa) {
        if (ssa == null) {
            return null;
        }
        ssa = ssa.trim();
        ssa = ssa.toLowerCase();
        ISignature result = null;
        if (ssa.equalsIgnoreCase("dsa") || ssa.equals("dss")) {
            result = new DSSSignature();
        } else if (ssa.startsWith("rsa-")) {
            result = RSASignatureFactory.getInstance(ssa);
        }
        return result;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet<String> hs = new HashSet<String>();
            hs.add("dss");
            hs.addAll(RSASignatureFactory.getNames());
            names = Collections.unmodifiableSet(hs);
        }
        return names;
    }
}

