/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenWordBoundary
extends REToken {
    private boolean negated;
    private int where;
    static final int BEGIN = 1;
    static final int END = 2;

    RETokenWordBoundary(int subIndex, int where, boolean negated) {
        super(subIndex);
        this.where = where;
        this.negated = negated;
    }

    int getMaximumLength() {
        return 0;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        char ch;
        boolean after = false;
        boolean before = false;
        if (((mymatch.eflags & 0x40) != 64 || mymatch.offset + mymatch.index > mymatch.anchor) && (ch = input.charAt(mymatch.index - 1)) != '\uffff') {
            boolean bl = before = Character.isLetterOrDigit(ch) || ch == '_';
        }
        if ((ch = input.charAt(mymatch.index)) != '\uffff') {
            after = Character.isLetterOrDigit(ch) || ch == '_';
        }
        boolean doNext = false;
        if ((this.where & 1) == 1) {
            boolean bl = doNext = after && !before;
        }
        if ((this.where & 2) == 2) {
            doNext ^= before && !after;
        }
        if (this.negated) {
            doNext = !doNext;
        }
        return doNext ? mymatch : null;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        if (this.matchThis(input, mymatch) != null) {
            return max;
        }
        return 0;
    }

    void dump(CPStringBuilder os) {
        if (this.where == 3) {
            os.append(this.negated ? "\\B" : "\\b");
        } else if (this.where == 1) {
            os.append("\\<");
        } else {
            os.append("\\>");
        }
    }
}

