/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;

public class SSL3
extends BasePad {
    public SSL3() {
        super("ssl3");
    }

    public void setup() {
        if (this.blockSize <= 0 || this.blockSize > 255) {
            throw new IllegalArgumentException("invalid block size: " + this.blockSize);
        }
    }

    public byte[] pad(byte[] in, int off, int len) {
        int padlen = this.blockSize - len % this.blockSize;
        byte[] pad = new byte[padlen];
        int i = 0;
        while (i < padlen) {
            pad[i] = (byte)(padlen - 1);
            ++i;
        }
        return pad;
    }

    public int unpad(byte[] in, int off, int len) throws WrongPaddingException {
        int padlen = in[off + len - 1] & 0xFF;
        if (padlen >= this.blockSize) {
            throw new WrongPaddingException();
        }
        return padlen + 1;
    }
}

