/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static final Map systemFlavorMaps = new WeakHashMap();
    private static final String GNU_JAVA_MIME_PREFIX = "gnu.java:";
    private HashMap<String, List<DataFlavor>> nativeToFlavorMap = new HashMap();
    private HashMap<DataFlavor, List<String>> flavorToNativeMap = new HashMap();

    private SystemFlavorMap() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    String sep = File.separator;
                    File propsFile = new File(String.valueOf(System.getProperty("gnu.classpath.home.url")) + sep + "accessibility.properties");
                    InputStream in = new FileInputStream(propsFile);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    String augmented = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                    if (augmented != null) {
                        URL url = new URL(augmented);
                        in = url.openStream();
                        props.load(in);
                    }
                    SystemFlavorMap.this.setupMapping(props);
                }
                catch (IOException iOException) {}
                return null;
            }
        });
    }

    void setupMapping(Properties props) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            try {
                List<String> nats;
                String nat = (String)propNames.nextElement();
                String mime = props.getProperty(nat);
                new MimeType(mime);
                DataFlavor flav = new DataFlavor(mime);
                List<DataFlavor> flavs = this.nativeToFlavorMap.get(nat);
                if (flavs == null) {
                    flavs = new ArrayList<DataFlavor>();
                    this.nativeToFlavorMap.put(nat, flavs);
                }
                if ((nats = this.flavorToNativeMap.get(flav)) == null) {
                    nats = new ArrayList<String>();
                    this.flavorToNativeMap.put(flav, nats);
                }
                flavs.add(flav);
                nats.add(nat);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (MimeTypeParseException mimeTypeParseException) {}
        }
    }

    @Override
    public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] flavors) {
        return new HashMap<DataFlavor, String>();
    }

    @Override
    public Map<String, DataFlavor> getFlavorsForNatives(String[] natives) {
        return new HashMap<String, DataFlavor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlavorMap getDefaultFlavorMap() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Map map = systemFlavorMaps;
        synchronized (map) {
            FlavorMap map2 = (FlavorMap)systemFlavorMaps.get(classLoader);
            if (map2 == null) {
                map2 = new SystemFlavorMap();
                systemFlavorMaps.put(classLoader, map2);
            }
            return map2;
        }
    }

    public static String encodeJavaMIMEType(String mime) {
        if (mime != null) {
            return GNU_JAVA_MIME_PREFIX + mime;
        }
        return null;
    }

    public static String encodeDataFlavor(DataFlavor df) {
        if (df != null) {
            return SystemFlavorMap.encodeJavaMIMEType(df.getMimeType());
        }
        return null;
    }

    public static boolean isJavaMIMEType(String name) {
        return name != null && name.startsWith(GNU_JAVA_MIME_PREFIX);
    }

    public static String decodeJavaMIMEType(String name) {
        if (SystemFlavorMap.isJavaMIMEType(name)) {
            return name.substring(GNU_JAVA_MIME_PREFIX.length());
        }
        return null;
    }

    public static DataFlavor decodeDataFlavor(String name) throws ClassNotFoundException {
        String javaMIMEType = SystemFlavorMap.decodeJavaMIMEType(name);
        if (javaMIMEType != null) {
            return new DataFlavor(javaMIMEType);
        }
        return null;
    }

    @Override
    public List<DataFlavor> getFlavorsForNative(String nat) {
        ArrayList<DataFlavor> ret = new ArrayList<DataFlavor>();
        if (nat == null) {
            Collection<List<DataFlavor>> all = this.nativeToFlavorMap.values();
            for (List<DataFlavor> list2 : all) {
                for (DataFlavor flav : list2) {
                    if (ret.contains(flav)) continue;
                    ret.add(flav);
                }
            }
        } else {
            List<DataFlavor> list3 = this.nativeToFlavorMap.get(nat);
            if (list3 != null) {
                ret.addAll(list3);
            }
        }
        return ret;
    }

    @Override
    public List<String> getNativesForFlavor(DataFlavor flav) {
        ArrayList<String> ret = new ArrayList<String>();
        if (flav == null) {
            Collection<List<String>> all = this.flavorToNativeMap.values();
            for (List<String> list2 : all) {
                for (String nat : list2) {
                    if (ret.contains(nat)) continue;
                    ret.add(nat);
                }
            }
        } else {
            List<String> list3 = this.flavorToNativeMap.get(flav);
            if (list3 != null) {
                ret.addAll(list3);
            }
        }
        return ret;
    }

    public synchronized void addFlavorForUnencodedNative(String nativeStr, DataFlavor flavor) {
        if (nativeStr == null || flavor == null) {
            throw new NullPointerException();
        }
        List<DataFlavor> flavors = this.nativeToFlavorMap.get(nativeStr);
        if (flavors == null) {
            flavors = new ArrayList<DataFlavor>();
            this.nativeToFlavorMap.put(nativeStr, flavors);
        } else if (!flavors.contains(flavor)) {
            flavors.add(flavor);
        }
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor flavor, String nativeStr) {
        if (nativeStr == null || flavor == null) {
            throw new NullPointerException();
        }
        List<String> natives = this.flavorToNativeMap.get(flavor);
        if (natives == null) {
            natives = new ArrayList<String>();
            this.flavorToNativeMap.put(flavor, natives);
        } else if (!natives.contains(nativeStr)) {
            natives.add(nativeStr);
        }
    }

    public synchronized void setNativesForFlavor(DataFlavor flavor, String[] natives) {
        if (natives == null || flavor == null) {
            throw new NullPointerException();
        }
        this.flavorToNativeMap.remove(flavor);
        int i = 0;
        while (i < natives.length) {
            this.addUnencodedNativeForFlavor(flavor, natives[i]);
            ++i;
        }
    }

    public synchronized void setFlavorsForNative(String nativeStr, DataFlavor[] flavors) {
        if (nativeStr == null || flavors == null) {
            throw new NullPointerException();
        }
        this.nativeToFlavorMap.remove(nativeStr);
        int i = 0;
        while (i < flavors.length) {
            this.addFlavorForUnencodedNative(nativeStr, flavors[i]);
            ++i;
        }
    }
}

