/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.util.Location;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionEvent
extends Event {
    private Object _instance;
    private Throwable _exception;
    private Thread _thread;
    private Location _location;
    private Location _catchLocation;
    private Class _klass;

    public ExceptionEvent(Throwable exception, Thread thread, Location location, Location catchLocation, Class clazz, Object instance) {
        super((byte)4);
        this._exception = exception;
        this._thread = thread;
        this._location = location;
        this._catchLocation = catchLocation;
        this._klass = clazz;
        this._instance = instance;
    }

    public Object getParameter(int type) {
        if (type == 2) {
            return this._thread;
        }
        if (type == 3) {
            return this._location;
        }
        if (type == 4) {
            return this._instance;
        }
        if (type == 1) {
            return this._klass;
        }
        if (type == 6) {
            return this._exception.getClass();
        }
        if (type == 7) {
            if (this._catchLocation.getMethod() != null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public void setCatchLoc(Location catchLoc) {
        this._catchLocation = catchLoc;
    }

    protected void _writeData(DataOutputStream outStream) throws IOException {
        VMIdManager idm = VMIdManager.getDefault();
        ThreadId tid = (ThreadId)idm.getObjectId(this._thread);
        ObjectId oid = idm.getObjectId(this._exception);
        tid.write(outStream);
        this._location.write(outStream);
        oid.writeTagged(outStream);
        this._catchLocation.write(outStream);
    }
}

