/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import gnu.classpath.SystemProperties;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;

public class DefaultMetalTheme
extends MetalTheme {
    private static final ColorUIResource PRIMARY1 = new ColorUIResource(102, 102, 153);
    private static final ColorUIResource PRIMARY2 = new ColorUIResource(153, 153, 204);
    private static final ColorUIResource PRIMARY3 = new ColorUIResource(204, 204, 255);
    private static final ColorUIResource SECONDARY1 = new ColorUIResource(102, 102, 102);
    private static final ColorUIResource SECONDARY2 = new ColorUIResource(153, 153, 153);
    private static final ColorUIResource SECONDARY3 = new ColorUIResource(204, 204, 204);
    private static final FontUIResource SUB_TEXT_FONT = new FontUIResource("Dialog", 0, 10);
    private static final FontUIResource SYSTEM_TEXT_FONT = new FontUIResource("Dialog", 0, 12);
    private static final FontUIResource USER_TEXT_FONT = new FontUIResource("Dialog", 0, 12);
    private static final FontUIResource WINDOW_TITLE_FONT = new FontUIResource("Dialog", 1, 12);
    private static final FontUIResource PLAIN_CONTROL_TEXT_FONT = new FontUIResource("Dialog", 0, 12);
    private static final FontUIResource BOLD_CONTROL_TEXT_FONT = new FontUIResource("Dialog", 1, 12);
    private static final FontUIResource PLAIN_MENU_TEXT_FONT = new FontUIResource("Dialog", 0, 12);
    private static final FontUIResource BOLD_MENU_TEXT_FONT = new FontUIResource("Dialog", 1, 12);
    static final int CONTROL_TEXT_FONT = 1;
    static final int MENU_TEXT_FONT = 2;

    public String getName() {
        return "Steel";
    }

    protected ColorUIResource getPrimary1() {
        return PRIMARY1;
    }

    protected ColorUIResource getPrimary2() {
        return PRIMARY2;
    }

    protected ColorUIResource getPrimary3() {
        return PRIMARY3;
    }

    protected ColorUIResource getSecondary1() {
        return SECONDARY1;
    }

    protected ColorUIResource getSecondary2() {
        return SECONDARY2;
    }

    protected ColorUIResource getSecondary3() {
        return SECONDARY3;
    }

    public FontUIResource getControlTextFont() {
        return this.getFont(1);
    }

    public FontUIResource getMenuTextFont() {
        return this.getFont(2);
    }

    public FontUIResource getSubTextFont() {
        return SUB_TEXT_FONT;
    }

    public FontUIResource getSystemTextFont() {
        return SYSTEM_TEXT_FONT;
    }

    public FontUIResource getUserTextFont() {
        return USER_TEXT_FONT;
    }

    public FontUIResource getWindowTitleFont() {
        return WINDOW_TITLE_FONT;
    }

    private FontUIResource getFont(int id) {
        FontUIResource font = null;
        switch (id) {
            case 1: {
                if (this.isBoldMetal()) {
                    font = BOLD_CONTROL_TEXT_FONT;
                    break;
                }
                font = PLAIN_CONTROL_TEXT_FONT;
                break;
            }
            case 2: {
                font = this.isBoldMetal() ? BOLD_MENU_TEXT_FONT : PLAIN_MENU_TEXT_FONT;
            }
        }
        return font;
    }

    private boolean isBoldMetal() {
        Object boldMetal = UIManager.get("swing.boldMetal");
        return (boldMetal == null || !Boolean.FALSE.equals(boldMetal)) && !"false".equals(SystemProperties.getProperty("swing.boldMetal"));
    }
}

