/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private OutputStream out;
    private Writer writer;
    private int streamState = 0;
    private static final int STATE_FRESH = 0;
    private static final int STATE_PUBLISHED = 1;
    private static final int STATE_CLOSED = 2;

    public StreamHandler() {
        this(null, null);
    }

    public StreamHandler(OutputStream out, Formatter formatter) {
        this(out, "java.util.logging.StreamHandler", Level.INFO, formatter, SimpleFormatter.class);
    }

    StreamHandler(OutputStream out, String propertyPrefix, Level defaultLevel, Formatter formatter, Class defaultFormatterClass) {
        this.level = LogManager.getLevelProperty(String.valueOf(propertyPrefix) + ".level", defaultLevel);
        this.filter = (Filter)LogManager.getInstanceProperty(String.valueOf(propertyPrefix) + ".filter", Filter.class, null);
        this.formatter = formatter != null ? formatter : (Formatter)LogManager.getInstanceProperty(String.valueOf(propertyPrefix) + ".formatter", Formatter.class, defaultFormatterClass);
        try {
            String enc = LogManager.getLogManager().getProperty(String.valueOf(propertyPrefix) + ".encoding");
            if (enc != null && enc.length() > 0) {
                new String(new byte[0], enc);
            }
            this.encoding = enc;
        }
        catch (Exception exception) {}
        if (out != null) {
            try {
                this.changeWriter(out, this.getEncoding());
            }
            catch (UnsupportedEncodingException uex) {
                throw new RuntimeException(uex.getMessage());
            }
        }
    }

    private void checkOpen() {
        if (this.streamState == 2) {
            throw new IllegalStateException(String.valueOf(this.toString()) + " has been closed");
        }
    }

    private void checkFresh() {
        this.checkOpen();
        if (this.streamState != 0) {
            throw new IllegalStateException("some log records have been published to " + this);
        }
    }

    private void changeWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, encoding);
        if (this.streamState != 0 || this.writer != null) {
            this.close();
        }
        this.writer = writer;
        this.out = out;
        this.encoding = encoding;
        this.streamState = 0;
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        this.checkFresh();
        if (this.out != null) {
            this.writer = encoding == null ? new OutputStreamWriter(this.out) : new OutputStreamWriter(this.out, encoding);
        }
    }

    protected void setOutputStream(OutputStream out) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        out.getClass();
        try {
            this.changeWriter(out, this.getEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void publish(LogRecord record) {
        String formattedMessage;
        if (!this.isLoggable(record)) {
            return;
        }
        if (this.streamState == 0) {
            try {
                this.writer.write(this.formatter.getHead(this));
            }
            catch (IOException ex) {
                this.reportError(null, ex, 1);
                return;
            }
            catch (Exception ex) {
                this.reportError(null, ex, 0);
                return;
            }
            this.streamState = 1;
        }
        try {
            formattedMessage = this.formatter.format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            this.writer.write(formattedMessage);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    public boolean isLoggable(LogRecord record) {
        return this.writer != null && super.isLoggable(record);
    }

    public void flush() {
        try {
            this.checkOpen();
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
    }

    public void close() throws SecurityException {
        LogManager.getLogManager().checkAccess();
        try {
            this.checkOpen();
            this.flush();
            if (this.writer != null) {
                if (this.formatter != null) {
                    if (this.streamState == 0) {
                        this.writer.write(this.formatter.getHead(this));
                    }
                    if (this.streamState != 2) {
                        this.writer.write(this.formatter.getTail(this));
                    }
                }
                this.streamState = 2;
                this.writer.close();
            }
        }
        catch (Exception ex) {
            this.reportError(null, ex, 3);
        }
    }
}

